/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.workflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.workflow.State;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BusinessService {
    @Size(max=256)
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @Size(max=256)
    @JsonProperty(value="uuid")
    private String uuid = null;
    @Size(max=256)
    @JsonProperty(value="businessService")
    private String businessService = null;
    @Size(max=256)
    @JsonProperty(value="business")
    private String business = null;
    @Size(max=1024)
    @JsonProperty(value="getUri")
    private String getUri = null;
    @Size(max=1024)
    @JsonProperty(value="postUri")
    private String postUri = null;
    @JsonProperty(value="businessServiceSla")
    private Long businessServiceSla = null;
    @NotNull
    @Valid
    @JsonProperty(value="states")
    private List<State> states = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;

    public BusinessService addStatesItem(State statesItem) {
        if (this.states == null) {
            this.states = new ArrayList<State>();
        }
        this.states.add(statesItem);
        return this;
    }

    public State getStateFromUuid(String uuid) {
        State state = null;
        if (this.states != null) {
            for (State s : this.states) {
                if (!s.getUuid().equalsIgnoreCase(uuid)) continue;
                state = s;
                break;
            }
        }
        return state;
    }

    public static BusinessServiceBuilder builder() {
        return new BusinessServiceBuilder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public String getBusiness() {
        return this.business;
    }

    public String getGetUri() {
        return this.getUri;
    }

    public String getPostUri() {
        return this.postUri;
    }

    public Long getBusinessServiceSla() {
        return this.businessServiceSla;
    }

    @NotNull
    public List<State> getStates() {
        return this.states;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="uuid")
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="business")
    public void setBusiness(String business) {
        this.business = business;
    }

    @JsonProperty(value="getUri")
    public void setGetUri(String getUri) {
        this.getUri = getUri;
    }

    @JsonProperty(value="postUri")
    public void setPostUri(String postUri) {
        this.postUri = postUri;
    }

    @JsonProperty(value="businessServiceSla")
    public void setBusinessServiceSla(Long businessServiceSla) {
        this.businessServiceSla = businessServiceSla;
    }

    @JsonProperty(value="states")
    public void setStates(@NotNull List<State> states) {
        this.states = states;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public BusinessService(String tenantId, String uuid, String businessService, String business, String getUri, String postUri, Long businessServiceSla, @NotNull List<State> states, AuditDetails auditDetails) {
        this.tenantId = tenantId;
        this.uuid = uuid;
        this.businessService = businessService;
        this.business = business;
        this.getUri = getUri;
        this.postUri = postUri;
        this.businessServiceSla = businessServiceSla;
        this.states = states;
        this.auditDetails = auditDetails;
    }

    public BusinessService() {
    }

    public String toString() {
        return "BusinessService(tenantId=" + this.getTenantId() + ", uuid=" + this.getUuid() + ", businessService=" + this.getBusinessService() + ", business=" + this.getBusiness() + ", getUri=" + this.getGetUri() + ", postUri=" + this.getPostUri() + ", businessServiceSla=" + this.getBusinessServiceSla() + ", states=" + this.getStates() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessService)) {
            return false;
        }
        BusinessService other = (BusinessService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        return !(this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        return result;
    }

    public static class BusinessServiceBuilder {
        private String tenantId;
        private String uuid;
        private String businessService;
        private String business;
        private String getUri;
        private String postUri;
        private Long businessServiceSla;
        private List<State> states;
        private AuditDetails auditDetails;

        BusinessServiceBuilder() {
        }

        @JsonProperty(value="tenantId")
        public BusinessServiceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="uuid")
        public BusinessServiceBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @JsonProperty(value="businessService")
        public BusinessServiceBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="business")
        public BusinessServiceBuilder business(String business) {
            this.business = business;
            return this;
        }

        @JsonProperty(value="getUri")
        public BusinessServiceBuilder getUri(String getUri) {
            this.getUri = getUri;
            return this;
        }

        @JsonProperty(value="postUri")
        public BusinessServiceBuilder postUri(String postUri) {
            this.postUri = postUri;
            return this;
        }

        @JsonProperty(value="businessServiceSla")
        public BusinessServiceBuilder businessServiceSla(Long businessServiceSla) {
            this.businessServiceSla = businessServiceSla;
            return this;
        }

        @JsonProperty(value="states")
        public BusinessServiceBuilder states(@NotNull List<State> states) {
            this.states = states;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BusinessServiceBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public BusinessService build() {
            return new BusinessService(this.tenantId, this.uuid, this.businessService, this.business, this.getUri, this.postUri, this.businessServiceSla, this.states, this.auditDetails);
        }

        public String toString() {
            return "BusinessService.BusinessServiceBuilder(tenantId=" + this.tenantId + ", uuid=" + this.uuid + ", businessService=" + this.businessService + ", business=" + this.business + ", getUri=" + this.getUri + ", postUri=" + this.postUri + ", businessServiceSla=" + this.businessServiceSla + ", states=" + this.states + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

