/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.workflow;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.egov.common.contract.models.AuditDetails;

public class Action {
    @Size(max=256)
    @JsonProperty(value="uuid")
    private String uuid;
    @Size(max=256)
    @JsonProperty(value="tenantId")
    private String tenantId;
    @Size(max=256)
    @JsonProperty(value="currentState")
    private String currentState;
    @Size(max=256)
    @JsonProperty(value="action")
    private String action;
    @Size(max=256)
    @JsonProperty(value="nextState")
    private String nextState;
    @Size(max=1024)
    @JsonProperty(value="roles")
    @Valid
    private List<String> roles;
    private AuditDetails auditDetails;

    public Action addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    public static ActionBuilder builder() {
        return new ActionBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getAction() {
        return this.action;
    }

    public String getNextState() {
        return this.nextState;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="uuid")
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="currentState")
    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    @JsonProperty(value="action")
    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="nextState")
    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public Action(String uuid, String tenantId, String currentState, String action, String nextState, List<String> roles, AuditDetails auditDetails) {
        this.uuid = uuid;
        this.tenantId = tenantId;
        this.currentState = currentState;
        this.action = action;
        this.nextState = nextState;
        this.roles = roles;
        this.auditDetails = auditDetails;
    }

    public Action() {
    }

    public String toString() {
        return "Action(uuid=" + this.getUuid() + ", tenantId=" + this.getTenantId() + ", currentState=" + this.getCurrentState() + ", action=" + this.getAction() + ", nextState=" + this.getNextState() + ", roles=" + this.getRoles() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$currentState = this.getCurrentState();
        String other$currentState = other.getCurrentState();
        if (this$currentState == null ? other$currentState != null : !this$currentState.equals(other$currentState)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $currentState = this.getCurrentState();
        result = result * 59 + ($currentState == null ? 43 : $currentState.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public static class ActionBuilder {
        private String uuid;
        private String tenantId;
        private String currentState;
        private String action;
        private String nextState;
        private List<String> roles;
        private AuditDetails auditDetails;

        ActionBuilder() {
        }

        @JsonProperty(value="uuid")
        public ActionBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ActionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="currentState")
        public ActionBuilder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @JsonProperty(value="action")
        public ActionBuilder action(String action) {
            this.action = action;
            return this;
        }

        @JsonProperty(value="nextState")
        public ActionBuilder nextState(String nextState) {
            this.nextState = nextState;
            return this;
        }

        @JsonProperty(value="roles")
        public ActionBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public ActionBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public Action build() {
            return new Action(this.uuid, this.tenantId, this.currentState, this.action, this.nextState, this.roles, this.auditDetails);
        }

        public String toString() {
            return "Action.ActionBuilder(uuid=" + this.uuid + ", tenantId=" + this.tenantId + ", currentState=" + this.currentState + ", action=" + this.action + ", nextState=" + this.nextState + ", roles=" + this.roles + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

