/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.egov.common.contract.models.Document;

public class Workflow {
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="comments")
    private String comments = null;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="assignes")
    @Valid
    private List<String> assignes = null;
    @JsonProperty(value="rating")
    private Integer rating = null;

    public Workflow addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public static WorkflowBuilder builder() {
        return new WorkflowBuilder();
    }

    public String getAction() {
        return this.action;
    }

    public String getComments() {
        return this.comments;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public List<String> getAssignes() {
        return this.assignes;
    }

    public Integer getRating() {
        return this.rating;
    }

    @JsonProperty(value="action")
    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="comments")
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="assignes")
    public void setAssignes(List<String> assignes) {
        this.assignes = assignes;
    }

    @JsonProperty(value="rating")
    public void setRating(Integer rating) {
        this.rating = rating;
    }

    public Workflow(String action, String comments, List<Document> documents, List<String> assignes, Integer rating) {
        this.action = action;
        this.comments = comments;
        this.documents = documents;
        this.assignes = assignes;
        this.rating = rating;
    }

    public Workflow() {
    }

    public static class WorkflowBuilder {
        private String action;
        private String comments;
        private List<Document> documents;
        private List<String> assignes;
        private Integer rating;

        WorkflowBuilder() {
        }

        @JsonProperty(value="action")
        public WorkflowBuilder action(String action) {
            this.action = action;
            return this;
        }

        @JsonProperty(value="comments")
        public WorkflowBuilder comments(String comments) {
            this.comments = comments;
            return this;
        }

        @JsonProperty(value="documents")
        public WorkflowBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="assignes")
        public WorkflowBuilder assignes(List<String> assignes) {
            this.assignes = assignes;
            return this;
        }

        @JsonProperty(value="rating")
        public WorkflowBuilder rating(Integer rating) {
            this.rating = rating;
            return this;
        }

        public Workflow build() {
            return new Workflow(this.action, this.comments, this.documents, this.assignes, this.rating);
        }

        public String toString() {
            return "Workflow.WorkflowBuilder(action=" + this.action + ", comments=" + this.comments + ", documents=" + this.documents + ", assignes=" + this.assignes + ", rating=" + this.rating + ")";
        }
    }
}

