/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.utils;

import java.util.regex.Pattern;
import org.egov.common.exception.InvalidTenantIdException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MultiStateInstanceUtil {
    public static String SCHEMA_REPLACE_STRING = "{schema}";
    @Value(value="${state.level.tenantid.length:1}")
    private Integer stateLevelTenantIdLength;
    @Value(value="${is.environment.central.instance:false}")
    private Boolean isEnvironmentCentralInstance;
    @Value(value="${state.schema.index.position.tenantid:1}")
    private Integer stateSchemaIndexPositionInTenantId;

    public String replaceSchemaPlaceholder(String query, String tenantId) throws InvalidTenantIdException {
        String finalQuery = null;
        if (tenantId.contains(".") && this.getIsEnvironmentCentralInstance().booleanValue()) {
            if (this.stateSchemaIndexPositionInTenantId >= tenantId.length()) {
                throw new InvalidTenantIdException("The tenantId length is smaller than the defined schema index in tenantId for central instance");
            }
            String schemaName = tenantId.split("\\.")[this.getStateSchemaIndexPositionInTenantId()];
            finalQuery = query.replaceAll("(?i)" + Pattern.quote(SCHEMA_REPLACE_STRING), schemaName);
        } else {
            finalQuery = query.replaceAll("(?i)" + Pattern.quote(SCHEMA_REPLACE_STRING.concat(".")), "");
        }
        return finalQuery;
    }

    public Boolean isTenantIdStateLevel(String tenantId) {
        if (this.getIsEnvironmentCentralInstance().booleanValue()) {
            int tenantLevel = tenantId.split("\\.").length;
            return tenantLevel <= this.stateLevelTenantIdLength;
        }
        return !tenantId.contains(".");
    }

    public String getStateLevelTenant(String tenantId) {
        String[] tenantArray = tenantId.split("\\.");
        String stateTenant = tenantArray[0];
        if (this.getIsEnvironmentCentralInstance().booleanValue()) {
            if (this.getStateLevelTenantIdLength() < tenantArray.length) {
                for (int i = 1; i < this.getStateLevelTenantIdLength(); ++i) {
                    stateTenant = stateTenant.concat(".").concat(tenantArray[i]);
                }
            } else {
                stateTenant = tenantId;
            }
        }
        return stateTenant;
    }

    public String getStateSpecificTopicName(String tenantId, String topic) {
        String[] tenants;
        String updatedTopic = topic;
        if (this.getIsEnvironmentCentralInstance().booleanValue() && (tenants = tenantId.split("\\.")).length > 1) {
            updatedTopic = tenants[this.stateSchemaIndexPositionInTenantId].concat("-").concat(topic);
        }
        return updatedTopic;
    }

    public Integer getStateLevelTenantIdLength() {
        return this.stateLevelTenantIdLength;
    }

    public Boolean getIsEnvironmentCentralInstance() {
        return this.isEnvironmentCentralInstance;
    }

    public Integer getStateSchemaIndexPositionInTenantId() {
        return this.stateSchemaIndexPositionInTenantId;
    }

    public MultiStateInstanceUtil(Integer stateLevelTenantIdLength, Boolean isEnvironmentCentralInstance, Integer stateSchemaIndexPositionInTenantId) {
        this.stateLevelTenantIdLength = stateLevelTenantIdLength;
        this.isEnvironmentCentralInstance = isEnvironmentCentralInstance;
        this.stateSchemaIndexPositionInTenantId = stateSchemaIndexPositionInTenantId;
    }

    public MultiStateInstanceUtil() {
    }
}

