/*
 * Decompiled with CFR 0.152.
 */
package org.egov.report.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.ReportApp;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.domain.model.MetaDataRequest;
import org.egov.domain.model.ReportDefinitions;
import org.egov.domain.model.Response;
import org.egov.report.repository.ReportRepository;
import org.egov.report.service.IntegrationService;
import org.egov.swagger.model.ColumnDetail;
import org.egov.swagger.model.MetadataResponse;
import org.egov.swagger.model.ReportDefinition;
import org.egov.swagger.model.ReportMetadata;
import org.egov.swagger.model.ReportRequest;
import org.egov.swagger.model.ReportResponse;
import org.egov.swagger.model.SearchColumn;
import org.egov.swagger.model.SourceColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private Response responseInfoFactory;
    @Autowired
    private IntegrationService integrationService;
    public static final Logger LOGGER = LoggerFactory.getLogger(ReportService.class);

    public MetadataResponse getMetaData(MetaDataRequest metaDataRequest) {
        ColumnDetail.TypeEnum te;
        MetadataResponse metadataResponse = new MetadataResponse();
        ReportDefinitions rds = ReportApp.getReportDefs();
        ReportDefinition reportDefinition = new ReportDefinition();
        LOGGER.info("updated repot defs " + ReportApp.getReportDefs() + "\n\n\n");
        reportDefinition = rds.getReportDefinition(metaDataRequest.getReportName());
        ReportMetadata rmt = new ReportMetadata();
        rmt.setReportName(reportDefinition.getReportName());
        rmt.setSummary(reportDefinition.getSummary());
        ArrayList<ColumnDetail> reportHeaders = new ArrayList<ColumnDetail>();
        ArrayList<ColumnDetail> searchParams = new ArrayList<ColumnDetail>();
        for (SourceColumn sourceColumn : reportDefinition.getSourceColumns()) {
            ColumnDetail reportheader = new ColumnDetail();
            reportheader.setLabel(sourceColumn.getLabel());
            reportheader.setName(sourceColumn.getName());
            te = ColumnDetail.TypeEnum.valueOf(sourceColumn.getType().toString().toUpperCase());
            reportheader.setType(te);
            reportHeaders.add(reportheader);
        }
        for (SearchColumn searchColumn : reportDefinition.getSearchParams()) {
            ColumnDetail sc = new ColumnDetail();
            te = ColumnDetail.TypeEnum.valueOf(searchColumn.getType().toString().toUpperCase());
            sc.setType(te);
            sc.setLabel(searchColumn.getLabel());
            sc.setName(searchColumn.getName());
            sc.setDefaultValue(searchColumn.getPattern());
            searchParams.add(sc);
        }
        rmt.setReportHeader(reportHeaders);
        rmt.setSearchParams(searchParams);
        metadataResponse.setReportDetails(rmt);
        metadataResponse.setTenantId(metaDataRequest.getTenantId());
        try {
            this.integrationService.getData(reportDefinition, metadataResponse, metaDataRequest.getRequestInfo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metadataResponse;
    }

    public ResponseEntity<?> getSuccessResponse(MetadataResponse metadataResponse, RequestInfo requestInfo, String tenantID) {
        MetadataResponse metadataResponses = new MetadataResponse();
        ResponseInfo responseInfo = this.responseInfoFactory.createResponseInfoFromRequestInfo(requestInfo, true);
        responseInfo.setStatus(HttpStatus.OK.toString());
        metadataResponses.setRequestInfo(responseInfo);
        metadataResponses.setTenantId(tenantID);
        metadataResponses.setReportDetails(metadataResponse.getReportDetails());
        return new ResponseEntity((Object)metadataResponses, HttpStatus.OK);
    }

    public ResponseEntity<?> getFailureResponse(RequestInfo requestInfo, String tenantID) {
        MetadataResponse metadataResponses = new MetadataResponse();
        ResponseInfo responseInfo = this.responseInfoFactory.createResponseInfoFromRequestInfo(requestInfo, false);
        responseInfo.setResMsgId("Report Defintion not found");
        metadataResponses.setRequestInfo(responseInfo);
        metadataResponses.setTenantId(tenantID);
        return new ResponseEntity((Object)metadataResponses, HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<?> reloadResponse(RequestInfo requestInfo) {
        MetadataResponse metadataResponses = new MetadataResponse();
        ResponseInfo responseInfo = this.responseInfoFactory.createResponseInfoFromRequestInfo(requestInfo, true);
        responseInfo.setResMsgId("Report reloaded successfully");
        metadataResponses.setRequestInfo(responseInfo);
        return new ResponseEntity((Object)metadataResponses, HttpStatus.OK);
    }

    public ReportResponse getReportData(ReportRequest reportRequest) {
        List<ReportDefinition> listReportDefinitions = ReportApp.getReportDefs().getReportDefinitions();
        ReportDefinition reportDefinition = listReportDefinitions.stream().filter(t -> t.getReportName().equals(reportRequest.getReportName())).findFirst().orElse(null);
        LOGGER.info("reportYamlMetaData::" + reportDefinition);
        List<Map<String, Object>> maps = this.reportRepository.getData(reportRequest, reportDefinition);
        List<SourceColumn> columns = reportDefinition.getSourceColumns();
        LOGGER.info("columns::" + columns);
        LOGGER.info("maps::" + maps);
        ReportResponse reportResponse = new ReportResponse();
        this.populateData(columns, maps, reportResponse);
        this.populateReportHeader(reportDefinition, reportResponse);
        return reportResponse;
    }

    private void populateData(List<SourceColumn> columns, List<Map<String, Object>> maps, ReportResponse reportResponse) {
        ArrayList<List<Object>> lists = new ArrayList<List<Object>>();
        for (int i = 0; i < maps.size(); ++i) {
            ArrayList<Object> objects = new ArrayList<Object>();
            Map<String, Object> map = maps.get(i);
            for (SourceColumn sourceColm : columns) {
                objects.add(map.get(sourceColm.getName()));
            }
            lists.add(objects);
        }
        reportResponse.setReportData(lists);
    }

    private void populateReportHeader(ReportDefinition reportDefinition, ReportResponse reportResponse) {
        String pattern = null;
        String defaultValue = null;
        List<SourceColumn> columns = reportDefinition.getSourceColumns();
        for (SourceColumn sc : columns) {
            pattern = "";
            defaultValue = "";
            if (sc.getLinkedReport() == null) continue;
            LOGGER.info("Linked Report Pattern is: " + sc.getLinkedReport());
            pattern = sc.getLinkedReport().getLinkedColumn();
            defaultValue = pattern.replace("{reportName}", sc.getLinkedReport().getReportName());
            sc.setDefaultValue(defaultValue.replace("{currentColumnName}", sc.getName()));
        }
        List<ColumnDetail> columnDetails = columns.stream().map(p -> new ColumnDetail(p.getLabel(), p.getType(), p.getDefaultValue(), p.getTotal(), p.getName())).collect(Collectors.toList());
        reportResponse.setReportHeader(columnDetails);
    }
}

