/*
 * Decompiled with CFR 0.152.
 */
package org.egov;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.annotation.PostConstruct;
import org.egov.domain.model.ReportDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.client.RestTemplate;

@Configuration
@PropertySource(value={"classpath:application.properties"})
@SpringBootApplication
public class ReportApp
implements EnvironmentAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(ReportApp.class);
    @Autowired
    public static ResourceLoader resourceLoader;
    @Autowired
    private static Environment env;
    @Autowired
    private static ReportDefinitions reportDefinitions;

    public void setEnvironment(Environment env) {
        ReportApp.env = env;
    }

    public ReportApp(ResourceLoader resourceLoader) {
        ReportApp.resourceLoader = resourceLoader;
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(ReportApp.class, (String[])args);
    }

    @PostConstruct
    @Bean(value={"reportDefinitions"})
    public static ReportDefinitions loadYaml() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            URL oracle = new URL(env.getProperty("report.yaml.path"));
            reportDefinitions = (ReportDefinitions)mapper.readValue((Reader)new InputStreamReader(oracle.openStream()), ReportDefinitions.class);
            LOGGER.info("Report Defintion PGR: " + reportDefinitions.toString());
            return reportDefinitions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return reportDefinitions;
        }
    }

    public static ReportDefinitions getReportDefs() {
        return reportDefinitions;
    }
}

