/*
 * Decompiled with CFR 0.152.
 */
package org.egov.controller;

import javax.validation.Valid;
import org.egov.ReportApp;
import org.egov.domain.model.MetaDataRequest;
import org.egov.domain.model.ReportDefinitions;
import org.egov.report.service.ReportService;
import org.egov.swagger.model.MetadataResponse;
import org.egov.swagger.model.ReportRequest;
import org.egov.swagger.model.ReportResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReportController {
    public ReportDefinitions reportDefinitions;
    @Autowired
    private ReportService reportService;
    @Autowired
    public static ResourceLoader resourceLoader;

    @Autowired
    public ReportController(ReportDefinitions reportDefinitions) {
        this.reportDefinitions = reportDefinitions;
    }

    @PostMapping(value={"/report/metadata/_get"})
    @ResponseBody
    public ResponseEntity<?> create(@RequestBody @Valid MetaDataRequest metaDataRequest, BindingResult errors) {
        try {
            MetadataResponse mdr = this.reportService.getMetaData(metaDataRequest);
            return this.reportService.getSuccessResponse(mdr, metaDataRequest.getRequestInfo(), metaDataRequest.getTenantId());
        }
        catch (NullPointerException e) {
            return this.reportService.getFailureResponse(metaDataRequest.getRequestInfo(), metaDataRequest.getTenantId());
        }
    }

    @PostMapping(value={"/report/_get"})
    @ResponseBody
    public ResponseEntity<?> getReportData(@RequestBody @Valid ReportRequest reportRequest, BindingResult errors) {
        try {
            ReportResponse reportResponse = this.reportService.getReportData(reportRequest);
            return new ResponseEntity((Object)reportResponse, HttpStatus.OK);
        }
        catch (NullPointerException e) {
            return this.reportService.getFailureResponse(reportRequest.getRequestInfo(), reportRequest.getTenantId());
        }
    }

    @PostMapping(value={"/report/_reload"})
    @ResponseBody
    public ResponseEntity<?> reloadYamlData(@RequestBody @Valid MetaDataRequest reportRequest, BindingResult errors) {
        ReportApp.loadYaml();
        return this.reportService.reloadResponse(reportRequest.getRequestInfo());
    }
}

