/*
 * Decompiled with CFR 0.152.
 */
package org.egov.report.service;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.egov.common.contract.request.RequestInfo;
import org.egov.swagger.model.ColumnDef;
import org.egov.swagger.model.ColumnDetail;
import org.egov.swagger.model.MetadataResponse;
import org.egov.swagger.model.ReportDefinition;
import org.egov.swagger.model.SearchColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegrationService {
    @Autowired
    private RestTemplate restTemplate;
    public static final Logger LOGGER = LoggerFactory.getLogger(IntegrationService.class);

    public MetadataResponse getData(ReportDefinition reportDefinition, MetadataResponse metadataResponse, RequestInfo requestInfo) {
        List searchColumns = reportDefinition.getSearchParams();
        List columnDetails = metadataResponse.getReportDetails().getSearchParams();
        Map colNameMap = columnDetails.stream().collect(Collectors.toMap(ColumnDef::getName, Function.identity()));
        LOGGER.info("colNameMap:" + colNameMap);
        for (SearchColumn searchColumn : searchColumns) {
            LOGGER.info("searchColumn:" + searchColumn);
            if (!searchColumn.getType().equals((Object)ColumnDetail.TypeEnum.SINGLEVALUELIST)) continue;
            LOGGER.info("if searchColumn:" + searchColumn);
            String[] patterns = searchColumn.getPattern().split("\\|");
            LOGGER.info("patterns:" + patterns.toString());
            String url = patterns[0];
            url = url.replaceAll("\\$tenantid", metadataResponse.getTenantId());
            LOGGER.info("url:" + url);
            ColumnDetail columnDetail = (ColumnDetail)colNameMap.get(searchColumn.getName());
            if (url != null && url.startsWith("list://")) {
                String[] pairs;
                url = url.substring(7);
                HashMap<String, String> map = new HashMap<String, String>();
                for (String str : pairs = url.split(",")) {
                    String[] keyValue = str.split(":");
                    System.out.println("KeyName is " + keyValue[0]);
                    System.out.println("KeyName is " + keyValue[1]);
                    map.put(keyValue[0], keyValue[1]);
                }
                columnDetail.setDefaultValue(map);
                continue;
            }
            String res = (String)this.restTemplate.postForObject(url, (Object)requestInfo, String.class, new Object[0]);
            Object document = Configuration.defaultConfiguration().jsonProvider().parse(res);
            LOGGER.info("document:" + document);
            List keys = (List)JsonPath.read((Object)document, (String)patterns[1], (Predicate[])new Predicate[0]);
            LOGGER.info("keys:" + keys);
            List values = (List)JsonPath.read((Object)document, (String)patterns[2], (Predicate[])new Predicate[0]);
            LOGGER.info("values:" + values);
            HashMap map = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i), values.get(i));
            }
            LOGGER.info("value map-->" + map);
            columnDetail.setDefaultValue(map);
        }
        return metadataResponse;
    }
}

