/*
 * Decompiled with CFR 0.152.
 */
package org.egov.models;

import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.NonNull;
import org.egov.enums.NoticeType;
import org.egov.models.AuditDetails;

public class Notice {
    @Size(min=4, max=128)
    @NonNull
    private String tenantId;
    @Size(min=4, max=128)
    private String upicNumber;
    @Size(min=4, max=64)
    private String applicationNo;
    @NotNull
    private String noticeDate;
    @Size(min=4, max=128)
    private String noticeNumber;
    @NotNull
    private NoticeType noticeType;
    @Size(min=4, max=128)
    @NotNull
    private String fileStoreId;
    private AuditDetails auditDetails;

    public static NoticeBuilder builder() {
        return new NoticeBuilder();
    }

    @ConstructorProperties(value={"tenantId", "upicNumber", "applicationNo", "noticeDate", "noticeNumber", "noticeType", "fileStoreId", "auditDetails"})
    public Notice(@NonNull String tenantId, String upicNumber, String applicationNo, String noticeDate, String noticeNumber, NoticeType noticeType, String fileStoreId, AuditDetails auditDetails) {
        if (tenantId == null) {
            throw new NullPointerException("tenantId");
        }
        this.tenantId = tenantId;
        this.upicNumber = upicNumber;
        this.applicationNo = applicationNo;
        this.noticeDate = noticeDate;
        this.noticeNumber = noticeNumber;
        this.noticeType = noticeType;
        this.fileStoreId = fileStoreId;
        this.auditDetails = auditDetails;
    }

    public Notice() {
    }

    @NonNull
    public String getTenantId() {
        return this.tenantId;
    }

    public String getUpicNumber() {
        return this.upicNumber;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public String getNoticeDate() {
        return this.noticeDate;
    }

    public String getNoticeNumber() {
        return this.noticeNumber;
    }

    public NoticeType getNoticeType() {
        return this.noticeType;
    }

    public String getFileStoreId() {
        return this.fileStoreId;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public void setTenantId(@NonNull String tenantId) {
        if (tenantId == null) {
            throw new NullPointerException("tenantId");
        }
        this.tenantId = tenantId;
    }

    public void setUpicNumber(String upicNumber) {
        this.upicNumber = upicNumber;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public void setNoticeDate(String noticeDate) {
        this.noticeDate = noticeDate;
    }

    public void setNoticeNumber(String noticeNumber) {
        this.noticeNumber = noticeNumber;
    }

    public void setNoticeType(NoticeType noticeType) {
        this.noticeType = noticeType;
    }

    public void setFileStoreId(String fileStoreId) {
        this.fileStoreId = fileStoreId;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public static class NoticeBuilder {
        private String tenantId;
        private String upicNumber;
        private String applicationNo;
        private String noticeDate;
        private String noticeNumber;
        private NoticeType noticeType;
        private String fileStoreId;
        private AuditDetails auditDetails;

        NoticeBuilder() {
        }

        public NoticeBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public NoticeBuilder upicNumber(String upicNumber) {
            this.upicNumber = upicNumber;
            return this;
        }

        public NoticeBuilder applicationNo(String applicationNo) {
            this.applicationNo = applicationNo;
            return this;
        }

        public NoticeBuilder noticeDate(String noticeDate) {
            this.noticeDate = noticeDate;
            return this;
        }

        public NoticeBuilder noticeNumber(String noticeNumber) {
            this.noticeNumber = noticeNumber;
            return this;
        }

        public NoticeBuilder noticeType(NoticeType noticeType) {
            this.noticeType = noticeType;
            return this;
        }

        public NoticeBuilder fileStoreId(String fileStoreId) {
            this.fileStoreId = fileStoreId;
            return this;
        }

        public NoticeBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public Notice build() {
            return new Notice(this.tenantId, this.upicNumber, this.applicationNo, this.noticeDate, this.noticeNumber, this.noticeType, this.fileStoreId, this.auditDetails);
        }

        public String toString() {
            return "Notice.NoticeBuilder(tenantId=" + this.tenantId + ", upicNumber=" + this.upicNumber + ", applicationNo=" + this.applicationNo + ", noticeDate=" + this.noticeDate + ", noticeNumber=" + this.noticeNumber + ", noticeType=" + (Object)((Object)this.noticeType) + ", fileStoreId=" + this.fileStoreId + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

