package org.egov.tracer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import java.util.List;

/**
 * Error object will be returned as a part of reponse body in conjunction with
 * responseHeader as part of ErrorResponse whenever the request processing status
 * in the responseHeader is FAILED.
 */
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class Error {
    @JsonProperty("code")
    private String code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("description")
    private String description = null;

    @JsonProperty("params")
    private List<String> params = null;

}
