/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.config;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import io.opentracing.contrib.web.servlet.filter.ServletFilterSpanDecorator;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnClass(value={WebMvcConfigurerAdapter.class})
@ConditionalOnProperty(name={"tracer.opentracing.enabled"}, havingValue="true", matchIfMissing=false)
public class OpenTracingConfiguration {
    @Bean
    public Tracer jaegerTracer() {
        return io.jaegertracing.Configuration.fromEnv().getTracer();
    }

    @Bean
    public List<ServletFilterSpanDecorator> spanDecorator() {
        ArrayList<ServletFilterSpanDecorator> decorators = new ArrayList<ServletFilterSpanDecorator>();
        decorators.add(ServletFilterSpanDecorator.STANDARD_TAGS);
        decorators.add(new ServletFilterSpanDecorator(){

            public void onRequest(HttpServletRequest httpServletRequest, Span span) {
                span.setTag("correlation.id", MDC.get((String)"CORRELATION_ID"));
            }

            public void onResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Span span) {
            }

            public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable, Span span) {
            }

            public void onTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l, Span span) {
            }
        });
        return decorators;
    }
}

