/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.egov.search.model.Definition;
import org.egov.search.model.Pagination;
import org.egov.search.model.Params;
import org.egov.search.model.Query;
import org.egov.search.model.SearchDefinition;
import org.egov.search.model.SearchParams;
import org.egov.search.model.SearchRequest;
import org.egov.tracer.model.CustomException;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SearchUtils {
    public static final Logger logger = LoggerFactory.getLogger(SearchUtils.class);
    @Value(value="${pagination.default.page.size}")
    private String defaultPageSize;
    @Value(value="${pagination.default.offset}")
    private String defaultOffset;

    public String buildQuery(SearchRequest searchRequest, SearchParams searchParam, Query query) {
        StringBuilder queryString = new StringBuilder();
        StringBuilder where = new StringBuilder();
        String finalQuery = null;
        queryString.append(query.getBaseQuery());
        String whereClause = this.buildWhereClause(searchRequest, searchParam);
        String paginationClause = this.getPaginationClause(searchRequest, searchParam.getPagination());
        if (null == whereClause) {
            return whereClause;
        }
        where.append(" where ( ").append(whereClause.toString() + " ) ");
        if (null != query.getGroupBy()) {
            queryString.append(" group by ").append(query.getGroupBy());
        }
        if (null != query.getOrderBy()) {
            where.append(" order by ").append(query.getOrderBy().split(",")[0]).append(" ").append(query.getOrderBy().split(",")[1]);
        }
        if (null != query.getSort()) {
            queryString.append(" " + query.getSort());
        }
        finalQuery = queryString.toString().replace("$where", where.toString());
        finalQuery = finalQuery.replace("$pagination", paginationClause);
        logger.info("Final Query: " + finalQuery);
        return finalQuery;
    }

    public String buildWhereClause(SearchRequest searchRequest, SearchParams searchParam) {
        StringBuilder whereClause = new StringBuilder();
        ObjectMapper mapper = new ObjectMapper();
        String condition = searchParam.getCondition();
        for (Params param : searchParam.getParams()) {
            Object paramValue = null;
            try {
                paramValue = JsonPath.read((String)mapper.writeValueAsString((Object)searchRequest), (String)param.getJsonPath(), (Predicate[])new Predicate[0]);
                if (null == paramValue) {
                }
            }
            catch (Exception e) {}
            continue;
            if (paramValue instanceof JSONArray) {
                JSONArray array = (JSONArray)paramValue;
                StringBuilder paramBuilder = new StringBuilder();
                for (int i = 0; i < array.size(); ++i) {
                    paramBuilder.append("'" + array.get(i) + "'");
                    if (i >= array.size() - 1) continue;
                    paramBuilder.append(",");
                }
                whereClause.append(param.getName()).append(" IN ").append("(").append(paramBuilder.toString()).append(")");
            } else {
                String operator;
                logger.debug("param: " + param.getName());
                String string = operator = null != param.getOperator() && !param.getOperator().isEmpty() ? param.getOperator() : "=";
                if (operator.equals("GE")) {
                    operator = ">=";
                }
                if (operator.equals("LE")) {
                    operator = "<=";
                }
                if (operator.equals("NE")) {
                    operator = "!=";
                }
                if (operator.equals("LIKE")) {
                    paramValue = "%" + paramValue + "%";
                }
                whereClause.append(param.getName()).append(" " + operator + " ").append("'" + paramValue + "'");
            }
            whereClause.append(" " + condition + " ");
        }
        Integer index = whereClause.toString().lastIndexOf(searchParam.getCondition());
        String where = whereClause.toString().substring(0, index);
        return where;
    }

    public String getPaginationClause(SearchRequest searchRequest, Pagination pagination) {
        StringBuilder paginationClause = new StringBuilder();
        ObjectMapper mapper = new ObjectMapper();
        Object limit = null;
        Object offset = null;
        if (null != pagination) {
            try {
                limit = JsonPath.read((String)mapper.writeValueAsString((Object)searchRequest), (String)pagination.getNoOfRecords(), (Predicate[])new Predicate[0]);
                offset = JsonPath.read((String)mapper.writeValueAsString((Object)searchRequest), (String)pagination.getOffset(), (Predicate[])new Predicate[0]);
            }
            catch (Exception e) {
                logger.error("Error while fetching limit and offset, using default values.");
            }
        }
        paginationClause.append(" LIMIT ").append(!StringUtils.isEmpty((CharSequence)(null != limit ? limit.toString() : null)) ? limit.toString() : this.defaultPageSize).append(" OFFSET ").append(!StringUtils.isEmpty((CharSequence)(null != offset ? offset.toString() : null)) ? offset.toString() : this.defaultOffset);
        return paginationClause.toString();
    }

    public Definition getSearchDefinition(Map<String, SearchDefinition> searchDefinitionMap, String moduleName, String searchName) {
        logger.debug("Fetching Definitions for module: " + moduleName + " and search feature: " + searchName);
        List definitions = null;
        try {
            definitions = searchDefinitionMap.get(moduleName).getDefinitions().parallelStream().filter(def -> def.getName().equals(searchName)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Search Definition provided for this search feature");
        }
        if (0 == definitions.size()) {
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Search Definition provided for this search feature");
        }
        return (Definition)definitions.get(0);
    }

    public List<String> convertPGOBjects(List<PGobject> maps) {
        ArrayList<String> result = new ArrayList<String>();
        if (null != maps || !maps.isEmpty()) {
            for (PGobject obj : maps) {
                if (null == obj.getValue()) break;
                String tuple = obj.toString();
                if (tuple.startsWith("[") && tuple.endsWith("]")) {
                    try {
                        org.json.JSONArray jsonArray = new org.json.JSONArray(tuple);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            result.add(jsonArray.get(i).toString());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Error while building json array!", (Throwable)e);
                        continue;
                    }
                }
                result.add(obj.getValue());
            }
        }
        return result;
    }
}

