/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.egov.SearchApplicationRunnerImpl;
import org.egov.search.model.Definition;
import org.egov.search.model.Params;
import org.egov.search.model.SearchParams;
import org.egov.search.model.SearchRequest;
import org.egov.search.utils.SearchUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchReqValidator {
    public static final Logger logger = LoggerFactory.getLogger(SearchReqValidator.class);
    @Autowired
    private SearchApplicationRunnerImpl runner;
    @Autowired
    private SearchUtils searchUtils;

    public void validate(SearchRequest searchRequest, String moduleName, String searchName) {
        logger.info("Validating search request....");
        this.checkIfEmptySearch(searchRequest);
        ConcurrentHashMap searchDefinitionMap = this.runner.getSearchDefinitionMap();
        Definition searchDefinition = null;
        searchDefinition = this.searchUtils.getSearchDefinition((Map)searchDefinitionMap, moduleName, searchName);
        this.validateSearchDefAgainstReq(searchDefinition, searchRequest);
        logger.info("All validations passed!");
    }

    public void validateSearchDefAgainstReq(Definition searchDefinition, SearchRequest searchRequest) {
        SearchParams searchParams = searchDefinition.getSearchParams();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (null == searchParams) {
            errorMap.put("400", "Missiing Configurations for: " + searchDefinition.getName());
        }
        ObjectMapper mapper = new ObjectMapper();
        List<Params> params = searchParams.getParams().parallelStream().filter(param -> param.getIsMandatory()).collect(Collectors.toList());
        params.forEach(entry -> {
            Object paramValue = null;
            try {
                paramValue = JsonPath.read((String)mapper.writeValueAsString((Object)searchRequest), (String)entry.getJsonPath(), (Predicate[])new Predicate[0]);
            }
            catch (Exception e) {
                errorMap.put("400", "Missiing Mandatory Property: " + entry.getJsonPath());
            }
            if (null == paramValue) {
                errorMap.put("400", "Missiing Mandatory Property: " + entry.getJsonPath());
            }
        });
        if (!errorMap.isEmpty()) {
            throw new CustomException(errorMap);
        }
    }

    public void checkIfEmptySearch(SearchRequest searchRequest) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (searchRequest.getRequestInfo() == null) {
            errorMap.put("400", "Requestinfo is missing: ");
            throw new CustomException(errorMap);
        }
        if (searchRequest.getSearchCriteria() == null) {
            errorMap.put("400", "Searchcriteria is missing: ");
            throw new CustomException(errorMap);
        }
    }
}

