/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.service;

import com.google.gson.Gson;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.egov.SearchApplicationRunnerImpl;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.search.model.Definition;
import org.egov.search.model.SearchRequest;
import org.egov.search.repository.SearchRepository;
import org.egov.search.utils.ResponseInfoFactory;
import org.egov.search.utils.SearchUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private SearchApplicationRunnerImpl runner;
    @Autowired
    private ResponseInfoFactory responseInfoFactory;
    @Autowired
    private SearchUtils searchUtils;
    public static final Logger logger = LoggerFactory.getLogger(SearchService.class);

    public Object searchData(SearchRequest searchRequest, String moduleName, String searchName) {
        ConcurrentHashMap searchDefinitionMap = this.runner.getSearchDefinitionMap();
        Definition searchDefinition = null;
        searchDefinition = this.searchUtils.getSearchDefinition((Map)searchDefinitionMap, moduleName, searchName);
        List maps = new ArrayList();
        try {
            maps = this.searchRepository.searchData(searchRequest, searchDefinition);
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new CustomException(HttpStatus.INTERNAL_SERVER_ERROR.toString(), "There was an error encountered at the Db");
        }
        String data = null;
        try {
            data = this.formatResult(maps, searchDefinition, searchRequest);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There was an error encountered while formatting the result, Verify output config from the yaml file.");
        }
        return data;
    }

    private String formatResult(List<String> maps, Definition searchDefinition, SearchRequest searchRequest) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        Gson gson = new Gson();
        List data = (List)gson.fromJson(maps.toString(), type);
        DocumentContext documentContext = JsonPath.parse((Object)(null != searchDefinition.getOutput().getJsonFormat() ? searchDefinition.getOutput().getJsonFormat() : "{}"));
        String[] expressionArray = searchDefinition.getOutput().getOutJsonPath().split("[.]");
        StringBuilder expression = new StringBuilder();
        for (int i = 0; i < expressionArray.length - 1; ++i) {
            expression.append(expressionArray[i]);
            if (i == expressionArray.length - 2) continue;
            expression.append(".");
        }
        documentContext.put(expression.toString(), expressionArray[expressionArray.length - 1], (Object)data, new Predicate[0]);
        ResponseInfo responseInfo = this.responseInfoFactory.createResponseInfoFromRequestInfo(searchRequest.getRequestInfo(), Boolean.valueOf(true));
        String[] resInfoExpArray = searchDefinition.getOutput().getResponseInfoPath().split("[.]");
        StringBuilder resInfoExp = new StringBuilder();
        for (int i = 0; i < resInfoExpArray.length - 1; ++i) {
            resInfoExp.append(resInfoExpArray[i]);
            if (i == resInfoExpArray.length - 2) continue;
            resInfoExp.append(".");
        }
        documentContext.put(resInfoExp.toString(), resInfoExpArray[resInfoExpArray.length - 1], (Object)responseInfo, new Predicate[0]);
        return documentContext.jsonString().toString();
    }

    public HashMap<String, String> fetchSearchCriteria(HashMap<String, String> searchCriteriafromBody, HashMap<String, String> searchCriteriafromUrl) {
        if ((searchCriteriafromBody == null || searchCriteriafromBody.isEmpty()) && (searchCriteriafromUrl == null || searchCriteriafromUrl.isEmpty())) {
            return null;
        }
        if (searchCriteriafromUrl == null || searchCriteriafromUrl.isEmpty()) {
            return searchCriteriafromBody;
        }
        if (searchCriteriafromBody == null || searchCriteriafromBody.isEmpty()) {
            return searchCriteriafromUrl;
        }
        searchCriteriafromBody.putAll(searchCriteriafromUrl);
        return searchCriteriafromBody;
    }
}

