/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.controller;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.egov.search.model.SearchRequest;
import org.egov.search.service.SearchService;
import org.egov.search.utils.SearchReqValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SearchController {
    @Autowired
    private SearchService searchService;
    @Autowired
    private SearchReqValidator searchReqValidator;
    @Autowired
    public static ResourceLoader resourceLoader;
    public static final Logger logger;

    @PostMapping(value={"/{moduleName}/{searchName}/_get"})
    @ResponseBody
    public ResponseEntity<?> fetchData(@RequestParam HashMap<String, String> allRequestParams, @PathVariable(value="moduleName") String moduleName, @PathVariable(value="searchName") String searchName, @RequestBody SearchRequest searchRequest) {
        long startTime = new Date().getTime();
        Object searchResult = null;
        try {
            searchRequest.setSearchCriteria((Object)this.searchService.fetchSearchCriteria((HashMap)searchRequest.getSearchCriteria(), allRequestParams));
            this.searchReqValidator.validate(searchRequest, moduleName, searchName);
            searchResult = this.searchService.searchData(searchRequest, moduleName, searchName);
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            Gson gson = new Gson();
            Map data = (Map)gson.fromJson(searchResult.toString(), type);
            long endTime = new Date().getTime();
            logger.info(" the time taken for search in controller in ms : " + (endTime - startTime));
            return new ResponseEntity((Object)data, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Exception while searching for result: ", (Throwable)e);
            if (null != searchResult) {
                return new ResponseEntity(searchResult, HttpStatus.OK);
            }
            throw e;
        }
    }

    static {
        logger = LoggerFactory.getLogger(SearchController.class);
    }
}

