/*
 * Decompiled with CFR 0.152.
 */
package org.egov;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.egov.search.model.SearchDefinition;
import org.egov.search.model.SearchDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class SearchApplicationRunnerImpl
implements ApplicationRunner {
    @Autowired
    public static ResourceLoader resourceLoader;
    @Autowired
    private static Environment env;
    @Value(value="${search.yaml.path}")
    private String yamllist;
    public static ConcurrentHashMap<String, SearchDefinition> searchDefinitionMap;
    public static final Logger logger;

    public void run(ApplicationArguments arg0) throws Exception {
        try {
            logger.info("Reading yaml files......");
            this.readFiles();
        }
        catch (Exception e) {
            logger.error("Exception while loading yaml files: ", (Throwable)e);
        }
    }

    public SearchApplicationRunnerImpl(ResourceLoader resourceLoader) {
        SearchApplicationRunnerImpl.resourceLoader = resourceLoader;
    }

    public void readFiles() {
        ConcurrentHashMap<String, SearchDefinition> map = new ConcurrentHashMap<String, SearchDefinition>();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SearchDefinitions searchDefinitions = null;
        try {
            List<String> ymlUrlS = Arrays.asList(this.yamllist.split(","));
            if (0 == ymlUrlS.size()) {
                ymlUrlS.add(this.yamllist);
            }
            for (String yamlLocation : ymlUrlS) {
                if (yamlLocation.startsWith("https://") || yamlLocation.startsWith("http://")) {
                    logger.info("Reading....: " + yamlLocation);
                    URL yamlFile = new URL(yamlLocation);
                    try {
                        searchDefinitions = (SearchDefinitions)mapper.readValue((Reader)new InputStreamReader(yamlFile.openStream()), SearchDefinitions.class);
                    }
                    catch (Exception e) {
                        logger.error("Exception while fetching search definitions for: " + yamlLocation + " = ", (Throwable)e);
                        continue;
                    }
                    logger.info("Parsed to object: " + searchDefinitions.toString());
                    map.put(searchDefinitions.getSearchDefinition().getModuleName(), searchDefinitions.getSearchDefinition());
                    continue;
                }
                if (!yamlLocation.startsWith("file://")) continue;
                logger.info("Reading....: " + yamlLocation);
                Resource resource = resourceLoader.getResource(yamlLocation);
                File file = resource.getFile();
                try {
                    searchDefinitions = (SearchDefinitions)mapper.readValue(file, SearchDefinitions.class);
                }
                catch (Exception e) {
                    logger.error("Exception while fetching search definitions for: " + yamlLocation + " = ", (Throwable)e);
                    continue;
                }
                logger.info("Parsed to object: " + searchDefinitions.toString());
                map.put(searchDefinitions.getSearchDefinition().getModuleName(), searchDefinitions.getSearchDefinition());
            }
        }
        catch (Exception e) {
            logger.error("Exception while loading yaml files: ", (Throwable)e);
        }
        searchDefinitionMap = map;
    }

    public ConcurrentHashMap<String, SearchDefinition> getSearchDefinitionMap() {
        return searchDefinitionMap;
    }

    static {
        searchDefinitionMap = new ConcurrentHashMap();
        logger = LoggerFactory.getLogger(SearchApplicationRunnerImpl.class);
    }
}

