/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.egov.dataupload.model.Definition;
import org.egov.dataupload.model.Document;
import org.egov.dataupload.model.UploadDefinition;
import org.egov.dataupload.utils.DataUploadUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class DataUploadUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataUploadUtils.class);
    private DateFormat format = new SimpleDateFormat("dd/MM/YYYY");
    private DataFormatter dataFormatter = new DataFormatter();
    @Value(value="${internal.file.folder.path}")
    private String internalFolderPath;
    @Value(value="${business.module.host}")
    private String businessModuleHost;
    @Autowired
    private ObjectMapper objectMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document readExcelFile(InputStream stream) throws IOException, InvalidFormatException {
        try (Workbook wb = WorkbookFactory.create((InputStream)stream);){
            Sheet sheet = wb.getSheetAt(0);
            ArrayList excelData = new ArrayList();
            ArrayList<String> columnHeaders = new ArrayList<String>();
            int rowStart = sheet.getFirstRowNum();
            int rowEnd = sheet.getLastRowNum();
            int totalRows = 0;
            logger.info("Total number of rows:  " + sheet.getPhysicalNumberOfRows());
            int rowNum = rowStart;
            while (true) {
                block33: {
                    int lastColumn;
                    Row row;
                    ArrayList<Object> dataList;
                    block34: {
                        block32: {
                            if (rowNum >= rowEnd + 1) break block32;
                            dataList = new ArrayList<Object>();
                            row = sheet.getRow(rowNum);
                            if (null == row) break block33;
                            lastColumn = 0;
                            lastColumn = rowNum == 0 ? (totalRows = row.getLastCellNum()) : Math.max(totalRows, row.getLastCellNum());
                            break block34;
                        }
                        Document document = new Document(columnHeaders, excelData);
                        return document;
                    }
                    block21: for (int colNum = 0; colNum < lastColumn; ++colNum) {
                        Cell cell = row.getCell(colNum, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                        if (null == cell) {
                            dataList.add(null);
                            continue;
                        }
                        if (0 == cell.getRowIndex()) {
                            columnHeaders.add(cell.getStringCellValue());
                            continue;
                        }
                        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellTypeEnum().ordinal()]) {
                            case 1: {
                                if (CellType.NUMERIC != cell.getCellTypeEnum()) continue block21;
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    dataList.add(cell.getDateCellValue().getTime());
                                    continue block21;
                                }
                                dataList.add(this.dataFormatter.formatCellValue(cell));
                                continue block21;
                            }
                            case 2: {
                                if (cell.getStringCellValue().equals("NA") || cell.getStringCellValue().equals("N/A") || cell.getStringCellValue().equals("na")) {
                                    dataList.add(null);
                                    continue block21;
                                }
                                if (this.validateDate(cell.getStringCellValue())) {
                                    try {
                                        Date date = this.format.parse(cell.getStringCellValue());
                                        dataList.add(date.getTime());
                                    }
                                    catch (Exception e) {
                                        logger.info("Couldn't parse date", (Throwable)e);
                                        dataList.add(cell.getStringCellValue());
                                    }
                                    continue block21;
                                }
                                if (!cell.getStringCellValue().trim().isEmpty()) {
                                    logger.trace("string: " + cell.getStringCellValue());
                                    dataList.add(cell.getStringCellValue());
                                    continue block21;
                                }
                                dataList.add(null);
                                continue block21;
                            }
                            case 3: {
                                dataList.add(cell.getBooleanCellValue());
                                continue block21;
                            }
                            case 4: {
                                dataList.add(null);
                                continue block21;
                            }
                        }
                    }
                    logger.info("dataList: " + dataList);
                    if (!dataList.isEmpty()) {
                        excelData.add(dataList);
                    }
                }
                ++rowNum;
            }
        }
        catch (IOException e) {
            logger.error("Unable to open stream.", (Throwable)e);
            throw e;
        }
        catch (InvalidFormatException e) {
            logger.error("Invalid format found, not an excel file. ", (Throwable)e);
            throw e;
        }
    }

    private boolean validateDate(String date) {
        boolean isValid = false;
        String dateRegex = "([0-9]{2})\\\\([0-9]{2})\\\\([0-9]{4})";
        if (date.matches(dateRegex)) {
            isValid = true;
        }
        return isValid;
    }

    private static boolean isCellEmpty(Cell cell) {
        return cell == null || cell.getCellTypeEnum() == CellType.BLANK || cell.getCellTypeEnum() == CellType.STRING && cell.getStringCellValue().isEmpty();
    }

    public Definition getUploadDefinition(Map<String, UploadDefinition> searchDefinitionMap, String moduleName, String defName) {
        logger.info("Fetching Definitions for module: " + moduleName + " and upload feature: " + defName);
        List definitions = searchDefinitionMap.get(moduleName).getDefinitions().stream().filter(def -> def.getName().equals(defName)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            logger.error("There's no Upload Definition provided for this upload feature");
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Upload Definition provided for this upload feature");
        }
        logger.info("Definition to be used: " + definitions.get(0));
        return (Definition)definitions.get(0);
    }

    public String getJsonPathKey(String jsonPath, StringBuilder expression) {
        String[] expressionArray = jsonPath.split("[.]");
        for (int j = 0; j < expressionArray.length - 1; ++j) {
            expression.append(expressionArray[j]);
            if (j == expressionArray.length - 2) continue;
            expression.append(".");
        }
        return expressionArray[expressionArray.length - 1];
    }

    /*
     * Exception decompiling
     */
    public String createANewFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeToexcelSheet(List<Object> rowData, String fileName) throws IOException {
        logger.info("Writing to file: " + fileName);
        try (FileInputStream stream = new FileInputStream(fileName);
             HSSFWorkbook workbook = new HSSFWorkbook((InputStream)stream);){
            HSSFSheet sheet = workbook.getSheetAt(0);
            int rowCount = sheet.getLastRowNum();
            HSSFRow row = sheet.createRow(++rowCount);
            for (int i = 0; i < rowData.size(); ++i) {
                Cell cell = row.createCell(i);
                if (rowData.get(i) instanceof String) {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(rowData.get(i).toString());
                    continue;
                }
                if (rowData.get(i) instanceof Double) {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue(Double.parseDouble(rowData.get(i).toString()));
                    continue;
                }
                if (rowData.get(i) instanceof Long) {
                    if (13 == rowData.get(i).toString().length()) {
                        HSSFCellStyle cellStyle = workbook.createCellStyle();
                        HSSFCreationHelper createHelper = workbook.getCreationHelper();
                        cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd/mm/yyyy"));
                        cell.setCellValue(new Date(Long.parseLong(rowData.get(i).toString())));
                        cell.setCellStyle((CellStyle)cellStyle);
                        continue;
                    }
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue((double)Long.parseLong(rowData.get(i).toString()));
                    continue;
                }
                if (rowData.get(i) instanceof Boolean) {
                    cell.setCellType(CellType.BOOLEAN);
                    cell.setCellValue(Boolean.parseBoolean(rowData.get(i).toString()));
                    continue;
                }
                if (Objects.isNull(rowData.get(i))) continue;
                cell.setCellType(CellType.STRING);
                cell.setCellValue(rowData.get(i).toString());
            }
            sheet.shiftRows(row.getRowNum(), rowCount, -1);
            try (FileOutputStream outputStream = new FileOutputStream(fileName);){
                workbook.write((OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            logger.error("Unable to write to output excel", (Throwable)e);
            throw e;
        }
    }

    public void clearInternalDirectory() {
        logger.info("Clearing the internal folder....: " + this.internalFolderPath);
        try {
            FileUtils.cleanDirectory((File)new File(this.internalFolderPath));
        }
        catch (Exception e) {
            logger.error("Couldn't clean the folder: " + this.internalFolderPath, (Throwable)e);
        }
    }

    public List<Object> getResJsonPathList(Map<String, String> resFieldsMap, List<Object> columnHeaders) {
        ArrayList<Object> jsonpathList = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : resFieldsMap.entrySet()) {
            columnHeaders.add(entry.getValue());
            jsonpathList.add(entry.getKey());
        }
        return jsonpathList;
    }

    public List<Object> fetchValuesFromResponse(Object response, List<Object> jsonPathList) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (Objects.isNull(response) || response instanceof String) {
            for (Object obj : jsonPathList) {
                values.add(null);
            }
        } else {
            try {
                String responseString = this.objectMapper.writeValueAsString(response);
                for (Object path : jsonPathList) {
                    try {
                        Object value = JsonPath.read((String)responseString, (String)path.toString(), (Predicate[])new Predicate[0]);
                        logger.debug("Response value from JSON Path {} is {}", (Object)path.toString(), value);
                        values.add(value);
                    }
                    catch (Exception e) {
                        values.add(null);
                    }
                }
            }
            catch (JsonProcessingException e) {
                for (Object obj : jsonPathList) {
                    values.add(null);
                }
            }
        }
        return values;
    }

    public String mockIdGen(String module, String defName) {
        StringBuilder id = new StringBuilder();
        id.append(module).append("-").append(defName).append("-").append(new Date().getTime());
        logger.info("JOB CODE: " + id.toString());
        return id.toString();
    }

    public String getURI(String endPoint) {
        logger.info("endpoint: " + endPoint);
        if (endPoint.contains("http://") || endPoint.contains("https://")) {
            return endPoint;
        }
        return this.businessModuleHost + endPoint;
    }

    public List<List<Object>> filter(List<List<Object>> excelData, List<Integer> indexes, List<Object> row) {
        List result = null;
        logger.info("indexes: " + indexes);
        for (Integer index : indexes) {
            logger.info("index: " + index);
            result = excelData.parallelStream().filter(obj -> obj.get(index).equals(row.get(index))).collect(Collectors.toList());
            excelData = result;
        }
        return result;
    }

    public static Map<String, List<List<Object>>> groupRowsByIndexes(List<List<Object>> excelData, List<Integer> indexes) {
        LinkedHashMap<String, List<List<Object>>> map = new LinkedHashMap<String, List<List<Object>>>();
        for (List<Object> data : excelData) {
            StringBuilder key = new StringBuilder();
            for (Integer index : indexes) {
                key.append(data.get(index));
            }
            if (map.containsKey(key.toString())) {
                ((List)map.get(key.toString())).add(data);
                continue;
            }
            ArrayList<List<Object>> list = new ArrayList<List<Object>>();
            list.add(data);
            map.put(key.toString(), list);
        }
        return map;
    }

    public Map<String, Object> eliminateEmptyList(Map<String, Object> objectMap) {
        for (String key : objectMap.keySet()) {
            if (key.equals("RequestInfo") || key.equals("requestInfo") || !(objectMap.get(key) instanceof Map)) continue;
            Map moduleObject = (Map)objectMap.get(key);
            for (String mapKey : moduleObject.keySet()) {
                if (!(moduleObject.get(mapKey) instanceof List) || ((List)moduleObject.get(mapKey)).isEmpty()) continue;
                logger.info("entering checkNull for: " + mapKey);
                if (!this.checkNullPropsOfObject(((List)moduleObject.get(mapKey)).get(0))) continue;
                logger.info("setting empty list for the key: " + mapKey);
                moduleObject.put(mapKey, new ArrayList());
            }
            objectMap.put(key, moduleObject);
        }
        return objectMap;
    }

    private boolean checkNullPropsOfObject(Object obj) {
        logger.info("Object: " + obj);
        if (obj instanceof Map) {
            Map objectMap = (Map)obj;
            for (Map.Entry entry : objectMap.entrySet()) {
                if (((String)entry.getKey()).equals("tenantId") || Objects.isNull(entry.getValue()) || entry.getValue().toString().isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<Integer> getIndexes(Definition uploadDefinition, List<String> columnHeaders) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String key : uploadDefinition.getUniqueParentKeys()) {
            indexes.add(columnHeaders.indexOf(key));
        }
        return indexes;
    }
}

