/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.egov.common.contract.request.RequestInfo;
import org.egov.dataupload.model.UploadJob;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.property.PropertyFileReader;
import org.egov.dataupload.property.models.AuditDetails;
import org.egov.dataupload.property.models.Property;
import org.egov.dataupload.repository.UploadRegistryRepository;
import org.egov.dataupload.service.DataUploadService;
import org.egov.dataupload.utils.DataUploadUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PropertyCustomUploader {
    private static final Logger log = LoggerFactory.getLogger(PropertyCustomUploader.class);
    @Autowired
    private DataUploadService dataUploadService;
    @Autowired
    private PropertyFileReader propFileReader;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private UploadRegistryRepository uploadRegistryRepository;
    @Autowired
    private DataUploadUtils uploadUtils;
    @Value(value="${property.host}")
    private String propertyHost;
    @Value(value="${property.create}")
    private String propertyCreate;
    @Value(value="${internal.file.folder.path}")
    private String internalFolderPath;
    @Value(value="${uploadjob.update.progress.size}")
    private int updateProgressSize;
    private String responseString = "Response";
    public static final String SUCCESSSTRING = "SUCCESS";
    public static final String FAILEDSTRING = "FAILED";

    public void uploadPropertyData(UploaderRequest uploaderRequest) {
        RequestInfo requestInfo = uploaderRequest.getRequestInfo();
        requestInfo.setTs(null);
        UploadJob job = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        String loc = job.getLocalFilePath();
        Map map = null;
        AuditDetails auditDetails = job.getAuditDetails();
        auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        job.setStartTime(Long.valueOf(System.currentTimeMillis()));
        job.setStatus(UploadJob.StatusEnum.INPROGRESS);
        this.dataUploadService.updateJobsWithPersister(auditDetails, job, false);
        try {
            map = this.propFileReader.parseExcel(loc);
        }
        catch (Exception e) {
            log.error(" exception occured while parsing the excel : ", (Throwable)e);
            job.setEndTime(Long.valueOf(System.currentTimeMillis()));
            job.setStatus(UploadJob.StatusEnum.FAILED);
            job.setReasonForFailure("Parsing of the excel failed:");
            this.dataUploadService.updateJobsWithPersister(auditDetails, job, false);
            this.uploadUtils.clearInternalDirectory();
            throw new CustomException("Exception Occured while parsing the excel", e.getMessage());
        }
        ArrayList<String> responses = new ArrayList<String>();
        int failCnt = 0;
        int sucCnt = 0;
        int recordCount = 1;
        for (Map.Entry entry : map.entrySet()) {
            String failureMessage = null;
            if (((String)entry.getKey()).contains("duplicate")) {
                ++failCnt;
                failureMessage = "FAILED--Duplicate property found";
            } else {
                Object response = this.dataUploadService.hitApi(this.getRequestForPost((Property)entry.getValue(), requestInfo), this.getUrlForPost());
                if (null == response) {
                    failureMessage = "FAILED--Module API failed with empty body in response";
                    ++failCnt;
                } else if (response instanceof String) {
                    failureMessage = "FAILED--" + response.toString();
                    ++failCnt;
                } else {
                    ++sucCnt;
                    failureMessage = "SUCCESS--" + this.getPropertyId(response);
                }
            }
            responses.add(failureMessage);
            if (recordCount % this.updateProgressSize == 0) {
                job.setSuccessfulRows(Integer.valueOf(sucCnt));
                job.setFailedRows(Integer.valueOf(failCnt));
                job.setStatus(UploadJob.StatusEnum.INPROGRESS);
                auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
                this.dataUploadService.updateJobsWithPersister(auditDetails, job, false);
            }
            ++recordCount;
        }
        this.writeToExcel(job, responses);
        auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        String s3Id = null;
        try {
            s3Id = this.dataUploadService.getFileStoreId(job.getTenantId(), job.getModuleName(), this.internalFolderPath + File.separator + job.getResponseFilePath());
        }
        catch (Exception e) {
            log.error(" upload of the excel sheet failed : ", (Throwable)e);
            job.setEndTime(Long.valueOf(System.currentTimeMillis()));
            job.setStatus(UploadJob.StatusEnum.FAILED);
            job.setReasonForFailure("upload of the excel sheet failed");
            this.dataUploadService.updateJobsWithPersister(auditDetails, job, false);
            this.uploadUtils.clearInternalDirectory();
            throw new CustomException("upload of the excel sheet failed", e.getMessage());
        }
        job.setResponseFilePath(s3Id);
        job.setEndTime(Long.valueOf(System.currentTimeMillis()));
        job.setFailedRows(Integer.valueOf(failCnt));
        job.setSuccessfulRows(Integer.valueOf(sucCnt));
        job.setStatus(UploadJob.StatusEnum.COMPLETED);
        job.setTotalRows(Integer.valueOf(map.size()));
        this.dataUploadService.updateJobsWithPersister(auditDetails, job, false);
        this.uploadUtils.clearInternalDirectory();
        log.info(" the id of s3 data : " + s3Id);
    }

    private String getPropertyId(Object response) {
        DocumentContext propRes = JsonPath.parse((Object)response);
        String propertyId = (String)propRes.read("$.Properties[0].propertyId", new Predicate[0]);
        String assMentNum = (String)propRes.read("$.Properties[0].propertyDetails[0].assessmentNumber", new Predicate[0]);
        return "propertyId : " + propertyId + " AND assessmentNumber : " + assMentNum;
    }

    private void writeToExcel(UploadJob job, List<String> resopnses) {
        FileInputStream myxls = null;
        XSSFWorkbook propertyExcel = null;
        String resPath = this.responseString + "-" + job.getCode() + "-" + job.getRequestFileName();
        job.setResponseFilePath(resPath);
        try {
            myxls = new FileInputStream(job.getLocalFilePath());
            propertyExcel = new XSSFWorkbook((InputStream)myxls);
            XSSFSheet propertySheet = propertyExcel.getSheet("Property_Detail");
            XSSFRow firstRow = propertySheet.getRow(0);
            short fixedResNum = firstRow.getLastCellNum();
            Cell lastCell = firstRow.getCell((int)fixedResNum);
            if (null != lastCell) {
                lastCell.setCellValue(this.responseString);
            } else {
                firstRow.createCell((int)fixedResNum).setCellValue("Status");
            }
            firstRow.createCell(fixedResNum + 1).setCellValue("Message");
            for (int i = 0; i < resopnses.size(); ++i) {
                XSSFRow currRow = propertySheet.getRow(i + 1);
                Cell resCell = currRow.createCell((int)fixedResNum);
                Cell msgCell = currRow.createCell(fixedResNum + 1);
                String value = resopnses.get(i);
                if (value.contains("--")) {
                    String[] valueArr = value.split("--");
                    resCell.setCellValue(valueArr[0]);
                    msgCell.setCellValue(valueArr[1]);
                    continue;
                }
                resCell.setCellValue(value);
            }
            myxls.close();
            FileOutputStream outputFile = new FileOutputStream(new File(this.internalFolderPath + File.separator + resPath));
            propertyExcel.write((OutputStream)outputFile);
            outputFile.close();
            log.info(" file is successfully written");
        }
        catch (Exception e) {
            log.error(" Exception occured while writing in sheet : ", (Throwable)e);
            job.setEndTime(Long.valueOf(System.currentTimeMillis()));
            job.setStatus(UploadJob.StatusEnum.FAILED);
            job.setReasonForFailure(" writing response in excel failed");
            this.dataUploadService.updateJobsWithPersister(job.getAuditDetails(), job, false);
            this.uploadUtils.clearInternalDirectory();
            throw new CustomException("Exception occured while writing in sheet", e.getMessage());
        }
        finally {
            if (null != myxls) {
                try {
                    myxls.close();
                }
                catch (IOException e) {
                    log.error("exception while closing resource in write file ");
                }
            }
            if (null != propertyExcel) {
                try {
                    propertyExcel.close();
                }
                catch (IOException e) {
                    log.error("exception while closing resource in write file ");
                }
            }
        }
    }

    private String getRequestForPost(Property property, RequestInfo requestInfo) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("RequestInfo", requestInfo);
        reqMap.put("Properties", Arrays.asList(property));
        String res = null;
        try {
            res = this.mapper.writeValueAsString(reqMap);
        }
        catch (JsonProcessingException e) {
            log.error(" Error occured while writing request map to string : ", (Throwable)e);
            throw new CustomException(" Error occured while writing request map to string : ", e.getMessage());
        }
        return res;
    }

    private String getUrlForPost() {
        return this.propertyHost.concat(this.propertyCreate);
    }
}

