/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.egov.dataupload.model.Document;
import org.egov.dataupload.service.ExcelIO;
import org.egov.dataupload.service.FileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thymeleaf.util.StringUtils;

@Component
public class ExcelIO
implements FileIO {
    private static final Logger logger = LoggerFactory.getLogger(ExcelIO.class);
    private static final DataFormatter dataFormatter = new DataFormatter();
    private DateFormat format = new SimpleDateFormat("dd/MM/YYYY");

    public boolean checkIfRowisEmpty(Row row, int lastColumn) {
        for (int colNum = 0; colNum < lastColumn; ++colNum) {
            Cell cell = row.getCell(colNum, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (null == cell || StringUtils.isEmpty((String)cell.getStringCellValue())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(InputStream stream) throws IOException {
        Throwable throwable;
        Workbook wb;
        try {
            wb = WorkbookFactory.create((InputStream)stream);
            throwable = null;
            try {
                Sheet sheet = wb.getSheetAt(0);
                ArrayList excelData = new ArrayList();
                ArrayList<String> columnHeaders = new ArrayList<String>();
                int rowStart = sheet.getFirstRowNum();
                int rowEnd = sheet.getLastRowNum();
                int totalRows = 0;
                logger.info("Total number of rows:  " + sheet.getPhysicalNumberOfRows());
                int rowNum = rowStart;
                while (rowNum < rowEnd + 1) {
                    int lastColumn;
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    Row row = sheet.getRow(rowNum);
                    if (null == row || this.checkIfRowisEmpty(row, lastColumn = rowNum == 0 ? (totalRows = row.getLastCellNum()) : Math.max(totalRows, row.getLastCellNum()))) return new Document(columnHeaders, excelData);
                    block21: for (int colNum = 0; colNum < lastColumn; ++colNum) {
                        Cell cell = row.getCell(colNum, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                        if (null == cell) {
                            dataList.add(null);
                            continue;
                        }
                        if (0 == cell.getRowIndex()) {
                            columnHeaders.add(cell.getStringCellValue());
                            continue;
                        }
                        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellTypeEnum().ordinal()]) {
                            case 1: {
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    dataList.add(this.format.format(new Date(cell.getDateCellValue().getTime())));
                                    continue block21;
                                }
                                if (this.validateEPoch(String.valueOf(cell.getNumericCellValue()))) {
                                    dataList.add(this.getEpoch(String.valueOf(cell.getNumericCellValue())));
                                    continue block21;
                                }
                                dataList.add(cell.getNumericCellValue());
                                continue block21;
                            }
                            case 2: {
                                if (cell.getStringCellValue().equals("NA") || cell.getStringCellValue().equals("N/A") || cell.getStringCellValue().equals("na")) {
                                    dataList.add(null);
                                    continue block21;
                                }
                                if (this.validateDate(cell.getStringCellValue())) {
                                    try {
                                        Date date = this.format.parse(cell.getStringCellValue());
                                        dataList.add(date.getTime());
                                    }
                                    catch (Exception e) {
                                        logger.info("Couldn't parse date", (Throwable)e);
                                        dataList.add(cell.getStringCellValue());
                                    }
                                    continue block21;
                                }
                                if (!cell.getStringCellValue().trim().isEmpty()) {
                                    logger.trace("string: " + cell.getStringCellValue());
                                    dataList.add(cell.getStringCellValue());
                                    continue block21;
                                }
                                dataList.add(null);
                                continue block21;
                            }
                            case 3: {
                                dataList.add(cell.getBooleanCellValue());
                                continue block21;
                            }
                            case 4: {
                                dataList.add(null);
                                continue block21;
                            }
                        }
                    }
                    logger.info("dataList: " + dataList);
                    if (!dataList.isEmpty()) {
                        excelData.add(dataList);
                    }
                    ++rowNum;
                }
                return new Document(columnHeaders, excelData);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            logger.error("Unable to open stream.", (Throwable)e);
            throw e;
        }
        catch (InvalidFormatException e) {
            logger.error("Invalid format found, not an excel file. ", (Throwable)e);
            throw new IOException("Invalid file format provided, not an excel file");
        }
        finally {
            if (wb != null) {
                if (throwable != null) {
                    try {
                        wb.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    wb.close();
                }
            }
        }
    }

    public void write(OutputStream stream, Document document) throws IOException {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet();
            int rowCount = 0;
            if (!document.getHeaders().isEmpty()) {
                Row row = sheet.createRow(rowCount++);
                this.populateRow(row, document.getHeaders());
            }
            for (List rowData : document.getRows()) {
                Row row = sheet.createRow(rowCount++);
                this.populateRow(row, rowData);
            }
            workbook.write(stream);
        }
        catch (IOException e) {
            logger.error("Unable to write to output excel", (Throwable)e);
            throw e;
        }
    }

    private boolean validateDate(String date) {
        boolean isValid = false;
        String dateRegex = "([0-9]{2})\\\\([0-9]{2})\\\\([0-9]{4})";
        if (date.matches(dateRegex)) {
            isValid = true;
        }
        return isValid;
    }

    private boolean validateEPoch(String value) {
        if (value.length() > 10) {
            return value.contains("E") && value.contains(".");
        }
        return false;
    }

    private Long getEpoch(String value) {
        DecimalFormat df = new DecimalFormat("#");
        df.setMaximumFractionDigits(0);
        String ret = df.format(Double.valueOf(value));
        return Long.valueOf(ret);
    }

    private <T> void populateRow(Row row, List<T> rowData) {
        int columnCount = 0;
        for (T column : rowData) {
            Cell cell = row.createCell(columnCount++);
            this.setCellValue(cell, column);
        }
    }

    private void setCellValue(Cell cell, Object columnValue) {
        if (columnValue instanceof String) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(columnValue.toString());
        } else if (columnValue instanceof Double) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(Double.parseDouble(columnValue.toString()));
        } else if (columnValue instanceof Long) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue((double)Long.parseLong(columnValue.toString()));
        } else if (columnValue instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(Boolean.parseBoolean(columnValue.toString()));
        } else if (!Objects.isNull(columnValue)) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(columnValue.toString());
        }
    }
}

