/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.egov.DataUploadApplicationRunnerImpl;
import org.egov.dataupload.model.Definition;
import org.egov.dataupload.model.Document;
import org.egov.dataupload.model.UploadDefinition;
import org.egov.dataupload.model.UploadJob;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.producer.DataUploadProducer;
import org.egov.dataupload.repository.DataUploadRepository;
import org.egov.dataupload.repository.UploadRegistryRepository;
import org.egov.dataupload.service.FileIO;
import org.egov.dataupload.utils.DataUploadUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class DataUploadServiceImpl {
    @Autowired
    private DataUploadRepository dataUploadRepository;
    @Autowired
    private UploadRegistryRepository uploadRegistryRepository;
    @Autowired
    private DataUploadApplicationRunnerImpl runner;
    @Autowired
    private DataUploadUtils dataUploadUtils;
    @Autowired
    private DataUploadProducer dataUploadProducer;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private FileIO excelIO;
    @Value(value="${filestore.host}")
    private String fileStoreHost;
    @Value(value="${filestore.get.endpoint}")
    private String getFileEndpoint;
    @Value(value="${response.file.name.prefix}")
    private String resFilePrefix;
    @Value(value="${template.download.prefix}")
    private String templateFilePrefix;
    private static final Logger logger = LoggerFactory.getLogger(DataUploadServiceImpl.class);

    public List<UploadJob> createUploadJob(UploaderRequest uploaderRequest) {
        UploadJob uploadJob = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        this.validateJob(uploadJob);
        StringBuilder uri = new StringBuilder();
        uri.append(this.fileStoreHost).append(this.getFileEndpoint).append("?fileStoreId=").append(uploadJob.getRequestFilePath()).append("&tenantId=").append(uploadJob.getTenantId());
        try {
            String filePath = this.dataUploadRepository.getFileContents(uri.toString(), ((UploadJob)uploaderRequest.getUploadJobs().get(0)).getRequestFileName());
            uploadJob.setCode(this.dataUploadUtils.mockIdGen(uploadJob.getModuleName(), uploadJob.getDefName()));
            uploadJob.setRequesterName(uploaderRequest.getRequestInfo().getUserInfo().getUserName());
            this.uploadRegistryRepository.createJob(uploaderRequest);
            uploadJob.setLocalFilePath(filePath);
            this.dataUploadProducer.producer(uploaderRequest);
            return uploaderRequest.getUploadJobs();
        }
        catch (IOException ioe) {
            throw new CustomException("400", "Unable to create or write file");
        }
        catch (RestClientException re) {
            logger.error("No .xls/.xlsx file found for: fileStoreId = " + uploadJob.getRequestFilePath() + " AND tenantId = " + uploadJob.getTenantId());
            throw new CustomException("400", "Unable to fetch file from filestore");
        }
        catch (DataAccessException de) {
            logger.error("Unable to persist job details onto DB", (Throwable)de);
            throw new CustomException("400", "Unable to persist job details onto DB");
        }
        catch (Exception e) {
            logger.error("Error occurred while attempting to create job", (Throwable)e);
            throw new CustomException("UNKNOWN_ERROR_OCCURRED", "UNKNOWN Error Occured");
        }
    }

    private void validateJob(UploadJob uploadJob) {
        if (Objects.isNull(uploadJob.getRequestFileName())) {
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "Please provide the requestFileName.");
        }
        Optional definitionOptional = this.runner.getUploadDefinition(uploadJob.getModuleName(), uploadJob.getDefName());
        if (!definitionOptional.isPresent()) {
            logger.error("There's no Upload Definition provided for this upload feature");
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Upload Definition provided for this upload feature");
        }
        Definition uploadDefinition = (Definition)definitionOptional.get();
        if (null != uploadDefinition.getIsParentChild() && uploadDefinition.getIsParentChild().booleanValue() && (null == uploadDefinition.getUniqueParentKeys() || uploadDefinition.getUniqueParentKeys().isEmpty())) {
            logger.error("Parent child relation is true, but there are no unique parent keys defined.");
            throw new CustomException("NO_UNIQUE_PARENT_KEYS", "Parent child relation is true, but there are no unique parent keys defined.");
        }
    }

    public void processExcel(UploaderRequest uploaderRequest) {
        UploadJob uploadJob = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        Definition uploadDefinition = null;
        try {
            UploadDefinition definition = (UploadDefinition)this.objectMapper.readValue((InputStream)new FileInputStream("C:\\Users\\Nithin\\Documents\\eGov\\egov-services\\core\\egov-data-uploader\\src\\main\\resources\\employee.json"), UploadDefinition.class);
            uploadDefinition = (Definition)definition.getDefinitions().get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Definition to be used: " + uploadDefinition);
        try (FileInputStream file = new FileInputStream(uploadJob.getLocalFilePath());){
            Document document = this.excelIO.read((InputStream)file);
            uploadJob.setEndTime(Long.valueOf(0L));
            uploadJob.setFailedRows(Integer.valueOf(0));
            uploadJob.setStartTime(Long.valueOf(new Date().getTime()));
            uploadJob.setSuccessfulRows(Integer.valueOf(0));
            uploadJob.setStatus(UploadJob.StatusEnum.INPROGRESS);
            uploadJob.setResponseFilePath(null);
            uploadJob.setTotalRows(Integer.valueOf(document.getRows().size()));
            this.uploadRegistryRepository.updateJob(uploadJob);
        }
        catch (IOException e) {
            logger.error("Unable to open file or invalid format provided.", (Throwable)e);
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setSuccessfulRows(Integer.valueOf(0));
            uploadJob.setStatus(UploadJob.StatusEnum.FAILED);
            uploadJob.setReasonForFailure(e.getMessage());
            this.uploadRegistryRepository.updateJob(uploadJob);
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "Unable to open file or invalid format provided.");
        }
    }
}

