/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.egov.DataUploadApplicationRunnerImpl;
import org.egov.dataupload.model.Definition;
import org.egov.dataupload.model.Defs;
import org.egov.dataupload.model.Document;
import org.egov.dataupload.model.JobSearchRequest;
import org.egov.dataupload.model.ModuleDefs;
import org.egov.dataupload.model.Request;
import org.egov.dataupload.model.UploadDefinition;
import org.egov.dataupload.model.UploadJob;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.producer.DataUploadProducer;
import org.egov.dataupload.property.models.AuditDetails;
import org.egov.dataupload.repository.DataUploadRepository;
import org.egov.dataupload.repository.UploadRegistryRepository;
import org.egov.dataupload.service.FileIO;
import org.egov.dataupload.utils.DataUploadUtils;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DataUploadService {
    @Autowired
    private DataUploadRepository dataUploadRepository;
    @Autowired
    private UploadRegistryRepository uploadRegistryRepository;
    @Autowired
    private DataUploadApplicationRunnerImpl runner;
    @Autowired
    private DataUploadUtils dataUploadUtils;
    @Autowired
    private DataUploadProducer dataUploadProducer;
    @Autowired
    private FileIO excelIO;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${filestore.host}")
    private String fileStoreHost;
    @Value(value="${egov.uploadJob.save.topic}")
    private String uploadJobSaveTopic;
    @Value(value="${egov.uploadJob.update.topic}")
    private String uploadJobUpdateTopic;
    @Value(value="${filestore.get.endpoint}")
    private String getFileEndpoint;
    @Value(value="${response.file.name.prefix}")
    private String resFilePrefix;
    @Value(value="${template.download.prefix}")
    private String templateFilePrefix;
    @Value(value="${property.module.name}")
    private String propertyModuleName;
    @Value(value="${uploadjob.update.progress.size}")
    private int updateProgressSize;
    private static final Logger logger = LoggerFactory.getLogger(DataUploadService.class);

    public List<UploadJob> createUploadJob(UploaderRequest uploaderRequest) {
        UploadJob uploadJob = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        this.validateJob(uploadJob);
        StringBuilder uri = new StringBuilder();
        uri.append(this.fileStoreHost).append(this.getFileEndpoint).append("?fileStoreId=").append(uploadJob.getRequestFilePath()).append("&tenantId=").append(uploadJob.getTenantId());
        try {
            String filePath = this.dataUploadRepository.getFileContents(uri.toString(), ((UploadJob)uploaderRequest.getUploadJobs().get(0)).getRequestFileName());
            uploadJob.setCode(this.dataUploadUtils.mockIdGen(uploadJob.getModuleName(), uploadJob.getDefName()));
            uploadJob.setRequesterName(uploaderRequest.getRequestInfo().getUserInfo().getUserName());
            AuditDetails auditDetails = AuditDetails.builder().createdBy(uploaderRequest.getRequestInfo().getUserInfo().getId().toString()).createdTime(Long.valueOf(new Date().getTime())).lastModifiedBy(uploaderRequest.getRequestInfo().getUserInfo().getId().toString()).lastModifiedTime(Long.valueOf(new Date().getTime())).build();
            uploadJob.setStatus(UploadJob.StatusEnum.NEW);
            this.updateJobsWithPersister(auditDetails, uploadJob, true);
            uploadJob.setLocalFilePath(filePath);
            this.dataUploadProducer.producer(uploaderRequest);
            return uploaderRequest.getUploadJobs();
        }
        catch (RestClientException re) {
            logger.error("No .xls/.xlsx file found for: fileStoreId = " + uploadJob.getRequestFilePath() + " AND tenantId = " + uploadJob.getTenantId());
            throw new CustomException("400", "Unable to fetch file from filestore");
        }
        catch (DataAccessException de) {
            logger.error("Unable to persist job details onto DB", (Throwable)de);
            throw new CustomException("400", "Unable to persist job details onto DB");
        }
        catch (Exception e) {
            logger.error("Error occurred while attempting to create job", (Throwable)e);
            throw new CustomException("UNKNOWN_ERROR_OCCURRED", "UNKNOWN Error Occured");
        }
    }

    private void validateJob(UploadJob uploadJob) {
        if (uploadJob.getModuleName().equalsIgnoreCase(this.propertyModuleName)) {
            return;
        }
        if (Objects.isNull(uploadJob.getRequestFileName())) {
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "Please provide the requestFileName.");
        }
        Optional definitionOptional = this.runner.getUploadDefinition(uploadJob.getModuleName(), uploadJob.getDefName());
        if (!definitionOptional.isPresent()) {
            logger.error("There's no Upload Definition provided for this upload feature");
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Upload Definition provided for this upload feature");
        }
        Definition uploadDefinition = (Definition)definitionOptional.get();
        if (null != uploadDefinition.getIsParentChild() && uploadDefinition.getIsParentChild().booleanValue() && (null == uploadDefinition.getUniqueParentKeys() || uploadDefinition.getUniqueParentKeys().isEmpty())) {
            logger.error("Parent child relation is true, but there are no unique parent keys defined.");
            throw new CustomException("NO_UNIQUE_PARENT_KEYS", "Parent child relation is true, but there are no unique parent keys defined.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excelDataUpload(UploaderRequest uploaderRequest) {
        UploadJob uploadJob = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        Optional definitionOptional = this.runner.getUploadDefinition(uploadJob.getModuleName(), uploadJob.getDefName());
        if (!definitionOptional.isPresent()) {
            logger.error("There's no Upload Definition provided for this upload feature");
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "There's no Upload Definition provided for this upload feature");
        }
        Definition uploadDefinition = (Definition)definitionOptional.get();
        logger.info("Definition to be used: " + uploadDefinition);
        AuditDetails auditDetails = uploadJob.getAuditDetails();
        auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        try (FileInputStream file = new FileInputStream(uploadJob.getLocalFilePath());){
            Document document = this.excelIO.read((InputStream)file);
            uploadJob.setEndTime(Long.valueOf(0L));
            uploadJob.setFailedRows(Integer.valueOf(0));
            uploadJob.setStartTime(Long.valueOf(new Date().getTime()));
            uploadJob.setSuccessfulRows(Integer.valueOf(0));
            uploadJob.setStatus(UploadJob.StatusEnum.INPROGRESS);
            uploadJob.setResponseFilePath(null);
            uploadJob.setTotalRows(Integer.valueOf(document.getRows().size()));
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
            if (null != uploadDefinition.getIsParentChild() && uploadDefinition.getIsParentChild().booleanValue()) {
                this.uploadParentChildData(document, uploadDefinition, uploaderRequest);
            } else {
                this.uploadFlatData(document, uploadDefinition, uploaderRequest);
            }
        }
        catch (IOException e) {
            logger.error("Unable to open file provided.", (Throwable)e);
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setSuccessfulRows(Integer.valueOf(0));
            uploadJob.setStatus(UploadJob.StatusEnum.fromValue((String)"failed"));
            uploadJob.setReasonForFailure(e.getMessage());
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
            throw new CustomException(HttpStatus.BAD_REQUEST.toString(), "Unable to open file provided.");
        }
        catch (Exception e) {
            logger.error("Unknown error ", (Throwable)e);
        }
        finally {
            this.dataUploadUtils.clearInternalDirectory();
        }
    }

    private void uploadFlatData(Document document, Definition uploadDefinition, UploaderRequest uploaderRequest) {
        ArrayList outputHeaders = new ArrayList(document.getHeaders());
        UploadJob uploadJob = (UploadJob)uploaderRequest.uploadJobs.get(0);
        List requests = uploadDefinition.getRequests();
        ArrayList documentContexts = new ArrayList();
        AuditDetails auditDetails = uploadJob.getAuditDetails();
        List responseJsonPathLists = this.initialiseUploadProcess(document, uploadDefinition, uploaderRequest, outputHeaders, uploadJob, requests, documentContexts, auditDetails);
        try {
            String resultFilePath = this.dataUploadUtils.createANewFile(this.resFilePrefix + uploadJob.getRequestFileName());
            this.dataUploadUtils.writeToexcelSheet(outputHeaders, resultFilePath);
            int successCount = 0;
            int failureCount = 0;
            int recordCount = 1;
            for (List row : document.getRows()) {
                Object previousResponse = null;
                String failureMessage = "";
                ArrayList responseFields = new ArrayList();
                for (int i = 0; i < uploadDefinition.getRequests().size(); ++i) {
                    Object response;
                    logger.debug("row: " + row.toString());
                    if (row.isEmpty()) continue;
                    String request = this.buildRequest(document.getHeaders(), (Request)requests.get(i), (DocumentContext)documentContexts.get(i), uploaderRequest, row, previousResponse);
                    previousResponse = response = this.hitApi(request, this.dataUploadUtils.getURI(((Request)requests.get(i)).getUrl()));
                    if (response == null) {
                        failureMessage = "Module API failed with empty body in response";
                    } else if (response instanceof String) {
                        failureMessage = (String)response;
                    }
                    responseFields.addAll(this.dataUploadUtils.fetchValuesFromResponse(response, (List)responseJsonPathLists.get(i)));
                }
                if (!failureMessage.isEmpty()) {
                    ++failureCount;
                    this.writeResultToExcel(failureMessage, row, responseFields, resultFilePath);
                } else {
                    ++successCount;
                    this.writeResultToExcel(failureMessage, row, responseFields, resultFilePath);
                }
                if (recordCount % this.updateProgressSize == 0) {
                    uploadJob.setSuccessfulRows(Integer.valueOf(successCount));
                    uploadJob.setFailedRows(Integer.valueOf(failureCount));
                    uploadJob.setStatus(UploadJob.StatusEnum.INPROGRESS);
                    auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
                    this.updateJobsWithPersister(auditDetails, uploadJob, false);
                }
                ++recordCount;
            }
            auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
            String responseFilePath = this.getFileStoreId(uploadJob.getTenantId(), uploadJob.getModuleName(), resultFilePath);
            uploadJob.setSuccessfulRows(Integer.valueOf(successCount));
            uploadJob.setFailedRows(Integer.valueOf(failureCount));
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setResponseFilePath(responseFilePath);
            uploadJob.setStatus(UploadJob.StatusEnum.COMPLETED);
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
        }
        catch (IOException e) {
            logger.error("Unable to write to output file.", (Throwable)e);
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setStatus(UploadJob.StatusEnum.FAILED);
            uploadJob.setReasonForFailure("IO_Exception, unable to write to output file");
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
            throw new CustomException("IO_EXCEPTION", "Unable to write to output file");
        }
    }

    public void updateJobsWithPersister(AuditDetails auditDetails, UploadJob uploadJob, boolean save) {
        uploadJob.setAuditDetails(auditDetails);
        HashMap<String, UploadJob> hashMap = new HashMap<String, UploadJob>();
        hashMap.put("UploadJob", uploadJob);
        if (save) {
            this.dataUploadProducer.push(this.uploadJobSaveTopic, hashMap);
        } else {
            this.dataUploadProducer.push(this.uploadJobUpdateTopic, hashMap);
        }
    }

    private void uploadParentChildData(Document document, Definition uploadDefinition, UploaderRequest uploaderRequest) {
        ArrayList outputHeaders = new ArrayList(document.getHeaders());
        UploadJob uploadJob = (UploadJob)uploaderRequest.uploadJobs.get(0);
        List requests = uploadDefinition.getRequests();
        ArrayList documentContexts = new ArrayList();
        AuditDetails auditDetails = uploadJob.getAuditDetails();
        List responseJsonPathLists = this.initialiseUploadProcess(document, uploadDefinition, uploaderRequest, outputHeaders, uploadJob, requests, documentContexts, auditDetails);
        try {
            String resultFilePath = this.dataUploadUtils.createANewFile(this.resFilePrefix + uploadJob.getRequestFileName());
            this.dataUploadUtils.writeToexcelSheet(outputHeaders, resultFilePath);
            int successCount = 0;
            int failureCount = 0;
            int recordCount = 0;
            List indexes = this.dataUploadUtils.getIndexes(uploadDefinition, document.getHeaders());
            List excelData = document.getRows();
            Map groupedRows = DataUploadUtils.groupRowsByIndexes((List)excelData, (List)indexes);
            Object previousResponse = null;
            List filteredList = null;
            for (Map.Entry entry : groupedRows.entrySet()) {
                ArrayList responseFields = new ArrayList();
                String failureMessage = "";
                for (int i = 0; i < uploadDefinition.getRequests().size(); ++i) {
                    Object response;
                    filteredList = (List)entry.getValue();
                    String request = this.buildRequestForParentChild(filteredList, document.getHeaders(), (Request)requests.get(i), uploadDefinition, (DocumentContext)documentContexts.get(i), uploaderRequest, previousResponse);
                    logger.info("FINAL REQUEST to EXTERNAL MODULE: " + request);
                    previousResponse = response = this.hitApi(request, this.dataUploadUtils.getURI(((Request)requests.get(i)).getUrl()));
                    if (null == response) {
                        failureMessage = "Module API failed with empty body in response";
                    } else if (response instanceof String) {
                        failureMessage = response.toString();
                    }
                    responseFields.addAll(this.dataUploadUtils.fetchValuesFromResponse(response, (List)responseJsonPathLists.get(i)));
                }
                if (!failureMessage.isEmpty()) {
                    ++failureCount;
                    this.writeResultToExcelParentChild(failureMessage, (List)entry.getValue(), responseFields, resultFilePath);
                } else {
                    ++successCount;
                    this.writeResultToExcelParentChild(failureMessage, (List)entry.getValue(), responseFields, resultFilePath);
                }
                if (recordCount % this.updateProgressSize == 0) {
                    uploadJob.setSuccessfulRows(Integer.valueOf(successCount));
                    uploadJob.setFailedRows(Integer.valueOf(failureCount));
                    uploadJob.setStatus(UploadJob.StatusEnum.INPROGRESS);
                    auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
                    this.updateJobsWithPersister(auditDetails, uploadJob, false);
                }
                ++recordCount;
            }
            auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
            String responseFilePath = this.getFileStoreId(uploadJob.getTenantId(), uploadJob.getModuleName(), resultFilePath);
            uploadJob.setSuccessfulRows(Integer.valueOf(successCount));
            uploadJob.setFailedRows(Integer.valueOf(failureCount));
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setResponseFilePath(responseFilePath);
            uploadJob.setStatus(UploadJob.StatusEnum.fromValue((String)"completed"));
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
        }
        catch (IOException e) {
            logger.error("Unable to write to output file.", (Throwable)e);
            uploadJob.setEndTime(Long.valueOf(new Date().getTime()));
            uploadJob.setStatus(UploadJob.StatusEnum.FAILED);
            uploadJob.setReasonForFailure("IO_Exception, unable to write to output file");
            this.updateJobsWithPersister(auditDetails, uploadJob, false);
            throw new CustomException("IO_EXCEPTION", "Unable to write to output file");
        }
    }

    private List<List<Object>> initialiseUploadProcess(Document document, Definition uploadDefinition, UploaderRequest uploaderRequest, List<Object> outputHeaders, UploadJob uploadJob, List<Request> requests, List<DocumentContext> documentContexts, AuditDetails auditDetails) {
        outputHeaders.add("status");
        outputHeaders.add("message");
        auditDetails.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        ArrayList<List<Object>> responseJsonPathLists = new ArrayList<List<Object>>();
        for (Request request : requests) {
            documentContexts.add(JsonPath.parse((Object)request.getApiRequest()));
            if (null != request.getAdditionalResFields()) {
                ArrayList resJsonPathList = new ArrayList();
                for (Map.Entry entry : request.getAdditionalResFields().entrySet()) {
                    outputHeaders.add(entry.getValue());
                    resJsonPathList.add(entry.getKey());
                }
                responseJsonPathLists.add(resJsonPathList);
                continue;
            }
            responseJsonPathLists.add(Collections.emptyList());
        }
        return responseJsonPathLists;
    }

    private String buildRequest(List<String> columnHeaders, Request request, DocumentContext documentContext, UploaderRequest uploaderRequest, List<Object> row, Object previousResponse) {
        logger.debug("row size: " + row.size());
        logger.debug("columnHeaders size: " + columnHeaders.size());
        for (int i = 0; i < columnHeaders.size(); ++i) {
            logger.debug("row val: " + row.get(i) + " coloumnHeader: " + columnHeaders.get(i));
            List jsonPathList = (List)request.getExcelHeadersToRequestMap().get(columnHeaders.get(i));
            if (null == jsonPathList || jsonPathList.isEmpty()) {
                logger.info("no jsonpath in config for: " + columnHeaders.get(i));
                continue;
            }
            for (String jsonPath : jsonPathList) {
                StringBuilder expression = new StringBuilder();
                String key2 = this.dataUploadUtils.getJsonPathKey(jsonPath, expression);
                documentContext.put(expression.toString(), key2, row.get(i), new Predicate[0]);
            }
        }
        logger.debug("Adding tenantId...");
        for (String path : request.getTenantIdPaths()) {
            StringBuilder expression = new StringBuilder();
            String key3 = this.dataUploadUtils.getJsonPathKey(path, expression);
            documentContext.put(expression.toString(), key3, (Object)((UploadJob)uploaderRequest.getUploadJobs().get(0)).getTenantId(), new Predicate[0]);
        }
        if (request.getPrevResponseToRequestMap() != null && !request.getPrevResponseToRequestMap().isEmpty() && previousResponse != null) {
            try {
                String response = this.objectMapper.writeValueAsString(previousResponse);
                request.getPrevResponseToRequestMap().forEach((key, value) -> {
                    String val = (String)JsonPath.read((String)response, (String)key, (Predicate[])new Predicate[0]);
                    for (String path : value) {
                        StringBuilder expression = new StringBuilder();
                        String targetJsonPath = this.dataUploadUtils.getJsonPathKey(path, expression);
                        documentContext.put(expression.toString(), targetJsonPath, (Object)val, new Predicate[0]);
                    }
                });
            }
            catch (JsonProcessingException e) {
                logger.error("Unable to parse previous response. " + previousResponse.toString());
            }
            catch (PathNotFoundException e) {
                logger.error("Unable to get requested value from previous response. ", (Throwable)e);
            }
        }
        documentContext.put("$", "RequestInfo", (Object)uploaderRequest.getRequestInfo(), new Predicate[0]);
        return documentContext.jsonString();
    }

    private void writeResultToExcel(String failureMessage, List<Object> row, List<Object> responseFields, String excelFilepath) throws IOException {
        if (!Objects.isNull(failureMessage) && !failureMessage.isEmpty()) {
            row.add("FAILED");
            row.add(failureMessage);
            row.addAll(responseFields);
        } else {
            row.add("SUCCESS");
            row.add("");
            row.addAll(responseFields);
        }
        this.dataUploadUtils.writeToexcelSheet(row, excelFilepath);
    }

    public Object hitApi(String request, String url) throws RestClientException {
        logger.debug("Request: " + request);
        logger.debug("URI: " + url);
        try {
            Map data = (Map)this.objectMapper.readValue(request, Map.class);
            return this.dataUploadRepository.doApiCall((Object)data, url);
        }
        catch (IOException e) {
            logger.error("Unable to deserialize the request to map.");
            return null;
        }
        catch (HttpClientErrorException e) {
            StringBuilder failureMessage = new StringBuilder();
            logger.error("Exception while hitting url: " + url + " with Exception: ", (Throwable)e);
            logger.error("response: " + e.getResponseBodyAsString());
            if (e.getResponseBodyAsString().isEmpty()) {
                failureMessage.append("API_ERROR_OCCURRED_").append(e.getRawStatusCode());
            } else {
                List errors = null;
                String response = e.getResponseBodyAsString();
                try {
                    errors = (List)JsonPath.read((String)response, (String)"$.Errors", (Predicate[])new Predicate[0]);
                }
                catch (PathNotFoundException pe) {
                    logger.error("Unable to get Errors object from Error Response, trying Error object");
                    try {
                        Error error = (Error)this.objectMapper.readValue(response, Error.class);
                        failureMessage.append(error.toString());
                        failureMessage.append(", ");
                    }
                    catch (PathNotFoundException | IOException error) {
                        // empty catch block
                    }
                }
                if (!Objects.isNull(errors)) {
                    for (Error error : errors) {
                        String errorObject = null;
                        try {
                            errorObject = this.objectMapper.writeValueAsString((Object)error);
                        }
                        catch (JsonProcessingException e1) {
                            logger.debug("Unable to parse error object");
                        }
                        failureMessage.append(JsonPath.read((String)errorObject, (String)"$.code", (Predicate[])new Predicate[0]).toString());
                        failureMessage.append(":");
                        failureMessage.append(JsonPath.read((String)errorObject, (String)"$.message", (Predicate[])new Predicate[0]).toString());
                        failureMessage.append(", ");
                    }
                    failureMessage.deleteCharAt(failureMessage.toString().length() - 2);
                } else {
                    failureMessage.append("API_ERROR_OCCURRED_").append(e.getRawStatusCode());
                }
            }
            logger.error(failureMessage.toString());
            return failureMessage.toString();
        }
        catch (Exception e) {
            return e.getClass().getSimpleName().concat("--").concat(e.getMessage());
        }
    }

    public String getFileStoreId(String tenantId, String module, String filePath) throws RestClientException, JsonProcessingException {
        logger.info("Uploading result excel to filestore....");
        Map result = this.dataUploadRepository.postFileContents(tenantId, module, filePath);
        List objects = (List)result.get("files");
        String id = (String)JsonPath.read((String)this.objectMapper.writeValueAsString(objects.get(0)), (String)"$.fileStoreId", (Predicate[])new Predicate[0]);
        logger.info("responsefile fileStoreId: " + id);
        return id;
    }

    public List<ModuleDefs> getModuleDefs() {
        logger.info("fetching definitions for upload....");
        Map uploadDefinitionMap = this.runner.getUploadDefinitionMap();
        ArrayList<ModuleDefs> result = new ArrayList<ModuleDefs>();
        for (Map.Entry entry : uploadDefinitionMap.entrySet()) {
            ModuleDefs moduleDefs = new ModuleDefs();
            moduleDefs.setName((String)entry.getKey());
            ArrayList<Defs> definitions = new ArrayList<Defs>();
            UploadDefinition uploadDefinition = (UploadDefinition)entry.getValue();
            for (Definition definition : uploadDefinition.getDefinitions()) {
                Defs def = Defs.builder().name(definition.getName()).templatePath(this.templateFilePrefix + "/" + definition.getTemplateFileName()).build();
                definitions.add(def);
            }
            moduleDefs.setDefinitions(definitions);
            result.add(moduleDefs);
        }
        logger.info("result: " + result);
        return result;
    }

    public List<UploadJob> getUploadJobs(JobSearchRequest jobSearchRequest) {
        logger.info("fetching upload jobs....");
        logger.info("JobSearchRequest: " + jobSearchRequest.toString());
        ArrayList<UploadJob> uploadJobs = new ArrayList();
        try {
            uploadJobs = this.uploadRegistryRepository.searchJob(jobSearchRequest);
        }
        catch (Exception e) {
            logger.error("Exception while searching for jobs", (Throwable)e);
        }
        return uploadJobs;
    }

    /*
     * WARNING - void declaration
     */
    private String buildRequestForParentChild(List<List<Object>> filteredList, List<String> columnHeaders, Request request, Definition uploadDefinition, DocumentContext documentContext, UploaderRequest uploaderRequest, Object previousResponse) throws IOException {
        UploadJob uploadJob = (UploadJob)uploaderRequest.uploadJobs.get(0);
        logger.debug("filteredList: " + filteredList);
        ArrayList<Object> filteredListObjects = new ArrayList<Object>();
        for (int k = 0; k < filteredList.size(); ++k) {
            for (int j = 0; j < columnHeaders.size(); ++j) {
                List jsonPathList = (List)request.getExcelHeadersToRequestMap().get(columnHeaders.get(j));
                if (Objects.isNull(jsonPathList) || jsonPathList.isEmpty()) {
                    logger.info("no jsonpath in config for: " + columnHeaders.get(j));
                    continue;
                }
                for (String jsonPath : jsonPathList) {
                    StringBuilder expression2 = new StringBuilder();
                    String key3 = this.dataUploadUtils.getJsonPathKey(jsonPath, expression2);
                    logger.debug("expression: " + expression2);
                    logger.debug("key: " + key3);
                    logger.debug("value: " + filteredList.get(k));
                    documentContext.put(expression2.toString(), key3, filteredList.get(k).get(j), new Predicate[0]);
                }
            }
            logger.info("Adding tenantId...");
            for (String path : request.getTenantIdPaths()) {
                StringBuilder stringBuilder = new StringBuilder();
                String key2 = this.dataUploadUtils.getJsonPathKey(path, stringBuilder);
                documentContext.put(stringBuilder.toString(), key2, (Object)uploadJob.getTenantId(), new Predicate[0]);
            }
            if (request.getPrevResponseToRequestMap() != null && !request.getPrevResponseToRequestMap().isEmpty() && previousResponse != null) {
                try {
                    String response = this.objectMapper.writeValueAsString(previousResponse);
                    request.getPrevResponseToRequestMap().forEach((key, value) -> {
                        Object val = ((JSONArray)JsonPath.read((String)response, (String)key, (Predicate[])new Predicate[0])).get(0);
                        for (String path : value) {
                            StringBuilder expression = new StringBuilder();
                            String targetJsonPath = this.dataUploadUtils.getJsonPathKey(path, expression);
                            documentContext.put(expression.toString(), targetJsonPath, val, new Predicate[0]);
                        }
                    });
                }
                catch (JsonProcessingException e) {
                    logger.error("Unable to parse previous response. " + previousResponse.toString());
                }
                catch (PathNotFoundException e) {
                    logger.error("Unable to get requested value from previous response. ", (Throwable)e);
                }
            }
            Object objectMap = (Map)this.objectMapper.readValue(documentContext.jsonString(), Map.class);
            objectMap = this.dataUploadUtils.eliminateEmptyList((Map)objectMap);
            filteredListObjects.add(objectMap);
        }
        ArrayList<String> uniqueKeysForInnerObject = new ArrayList<String>();
        if (uploadDefinition.getUniqueKeysForInnerObject() != null) {
            for (Object col : uploadDefinition.getUniqueKeysForInnerObject()) {
                StringBuilder stringBuilder = new StringBuilder();
                String key2 = this.dataUploadUtils.getJsonPathKey((String)((List)request.getExcelHeadersToRequestMap().get(col)).get(0), stringBuilder);
                uniqueKeysForInnerObject.add(key2);
            }
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        for (Map map : filteredListObjects) {
            DataUploadService.deepMerge(requestMap, (Map)map, uniqueKeysForInnerObject);
        }
        logger.debug("requestMap: " + requestMap);
        try {
            requestMap.put("RequestInfo", uploaderRequest.getRequestInfo());
            if (!StringUtils.isEmpty((CharSequence)request.getArrayPath())) {
                String oldKey = null;
                Object var13_25 = null;
                for (String key4 : requestMap.keySet()) {
                    if (key4.equals("RequestInfo")) continue;
                    oldKey = key4;
                    ArrayList list = new ArrayList();
                    list.add(requestMap.get(key4));
                    ArrayList arrayList = list;
                }
                if (!StringUtils.isEmpty(oldKey)) {
                    void var13_26;
                    requestMap.put(oldKey, var13_26);
                }
            }
        }
        catch (Exception e) {
            logger.error("Couldn't add Data: ", (Throwable)e);
        }
        String requestContentBody = null;
        try {
            requestContentBody = this.objectMapper.writeValueAsString(requestMap);
        }
        catch (Exception exception) {
            logger.error("Exception while parsing requestMap to String", (Throwable)exception);
        }
        return requestContentBody.toString();
    }

    private static Map deepMerge(Map original, Map newMap, List<String> uniqueKeysForInnerObject) {
        for (Object key : newMap.keySet()) {
            Object newChild;
            Object originalChild;
            logger.debug("key: " + key);
            if (newMap.get(key) instanceof Map && original.get(key) instanceof Map) {
                originalChild = (Map)original.get(key);
                newChild = (Map)newMap.get(key);
                original.put(key, DataUploadService.deepMerge((Map)originalChild, (Map)newChild, uniqueKeysForInnerObject));
                continue;
            }
            if (newMap.get(key) instanceof List && original.get(key) instanceof List) {
                logger.debug("Instance of list: ");
                originalChild = (List)original.get(key);
                logger.debug("originalChild: " + originalChild);
                newChild = (List)newMap.get(key);
                logger.debug("newChild: " + newChild);
                if (originalChild.isEmpty() || newChild.isEmpty() || originalChild.containsAll((Collection<?>)newChild)) continue;
                Map originalChildEntry = (Map)originalChild.get(originalChild.size() - 1);
                Map newChildEntry = (Map)newChild.get(0);
                int counter = 0;
                try {
                    for (String mapKey : uniqueKeysForInnerObject) {
                        if (!originalChildEntry.get(mapKey).equals(newChildEntry.get(mapKey))) break;
                        ++counter;
                    }
                    if (counter == uniqueKeysForInnerObject.size() && counter != 0) {
                        logger.debug("Match found!");
                        for (String originalMapKey : originalChildEntry.keySet()) {
                            if (!(originalChildEntry.get(originalMapKey) instanceof List)) continue;
                            List newChildValue = (List)newChildEntry.get(originalMapKey);
                            List originalChildValue = (List)originalChildEntry.get(originalMapKey);
                            originalChildValue.addAll(newChildValue);
                            originalChildEntry.put(originalMapKey, originalChildValue);
                        }
                        continue;
                    }
                    logger.debug("No match found!");
                    originalChild.add(newChildEntry);
                }
                catch (Exception e) {
                    if (originalChild.contains(newChildEntry)) continue;
                    originalChild.add(newChildEntry);
                }
                continue;
            }
            logger.debug("Adding new key: " + key + " value: " + newMap.get(key) + " to original");
            original.put(key, newMap.get(key));
        }
        return original;
    }

    private void writeResultToExcelParentChild(String failureMessage, List<List<Object>> rows, List<Object> responseFields, String outputExcelFilepath) throws IOException {
        for (List<Object> row : rows) {
            this.writeResultToExcel(failureMessage, row, responseFields, outputExcelFilepath);
        }
    }
}

