/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.dataupload.model.JobSearchRequest;
import org.egov.dataupload.model.UploadJob;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.repository.DataUploadQueryBuilder;
import org.egov.dataupload.repository.UploadJobRowMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class UploadRegistryRepository {
    public static final Logger logger = LoggerFactory.getLogger(UploadRegistryRepository.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private UploadJobRowMapper uploadJobRowMapper;
    @Autowired
    private DataUploadQueryBuilder dataUploadQueryBuilder;

    public void createJob(UploaderRequest uploaderRequest) {
        String query = "Insert into EGDU_UPLOADREGISTRY(CODE, TENANTID, REQUESTFILE_PATH, MODULE_NAME, DEF_NAME, REQUESTER_NAME,STATUS,FILE_NAME,CREATEDBY,CREATEDDATE,LASTMODIFIEDBY,LASTMODIFIEDDATE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
        UploadJob uploadJob = (UploadJob)uploaderRequest.getUploadJobs().get(0);
        try {
            this.jdbcTemplate.update(query, new Object[]{uploadJob.getCode(), uploadJob.getTenantId(), uploadJob.getRequestFilePath(), uploadJob.getModuleName(), uploadJob.getDefName(), uploadJob.getRequesterName(), UploadJob.StatusEnum.valueOf((String)"NEW").toString(), uploadJob.getRequestFileName(), uploaderRequest.getRequestInfo().getUserInfo().getId(), new Date().getTime(), uploaderRequest.getRequestInfo().getUserInfo().getId(), new Date().getTime()});
        }
        catch (DataAccessException e) {
            logger.error("Exception while creating job in db for job code: " + uploadJob.getCode(), (Throwable)e);
            throw e;
        }
    }

    public void updateJob(UploadJob uploadJob) {
        String query = "Update EGDU_UPLOADREGISTRY set START_TIME=?, END_TIME=?, TOTAL_ROWS=?, SUCCESS_ROWS=?, FAILED_ROWS=?, RESPONSEFILE_PATH=?, STATUS=?, REASON_FOR_FAILURE = ? where CODE=? AND TENANTID=?";
        try {
            this.jdbcTemplate.update(query, new Object[]{uploadJob.getStartTime(), uploadJob.getEndTime(), uploadJob.getTotalRows(), uploadJob.getSuccessfulRows(), uploadJob.getFailedRows(), uploadJob.getResponseFilePath(), uploadJob.getStatus().toString(), uploadJob.getReasonForFailure(), uploadJob.getCode(), uploadJob.getTenantId()});
        }
        catch (Exception e) {
            logger.error("Exception while updating job in db for job code: " + uploadJob.getCode(), (Throwable)e);
        }
    }

    public List<UploadJob> searchJob(JobSearchRequest jobSearchRequest) {
        ArrayList preparedStatementValues = new ArrayList();
        String query = this.dataUploadQueryBuilder.getQuery(jobSearchRequest, preparedStatementValues);
        ArrayList<UploadJob> uploadJobs = new ArrayList();
        uploadJobs = this.jdbcTemplate.query(query, preparedStatementValues.toArray(), (RowMapper)this.uploadJobRowMapper);
        return uploadJobs;
    }
}

