/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.egov.dataupload.utils.DataUploadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Repository
public class DataUploadRepository {
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${filestore.post.endpoint}")
    private String postFilePath;
    @Value(value="${filestore.host}")
    private String fileStoreHost;
    @Autowired
    private DataUploadUtils dataUploadUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataUploadRepository.class);

    public Object doApiCall(Object request, String url) throws RestClientException {
        LOGGER.info("Making restTemplate call.....");
        return this.restTemplate.postForObject(url, request, Map.class, new Object[0]);
    }

    public String getFileContents(String url, String fileName) throws IOException, RestClientException {
        ArrayList<ByteArrayHttpMessageConverter> messageConverters = new ArrayList<ByteArrayHttpMessageConverter>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate(messageConverters);
        String filePath = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
            if (response.getStatusCode() == HttpStatus.OK) {
                filePath = this.dataUploadUtils.createANewFile(fileName);
                Files.write(Paths.get(filePath, new String[0]), (byte[])response.getBody(), new OpenOption[0]);
            }
        }
        catch (RestClientException re) {
            LOGGER.error("Exception while fetching file from: " + url, (Throwable)re);
            throw re;
        }
        return filePath;
    }

    public Map<String, Object> postFileContents(String tenantId, String moduleName, String filePath) throws RestClientException {
        Map result;
        StringBuilder uri = new StringBuilder();
        uri.append(this.fileStoreHost).append(this.postFilePath).append("?tenantId=").append(tenantId).append("&module=").append(moduleName);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"file", (Object)new FileSystemResource(filePath));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        LOGGER.info("URI: " + uri.toString());
        try {
            ResponseEntity resultMap = this.restTemplate.exchange(uri.toString(), HttpMethod.POST, requestEntity, Map.class, new Object[0]);
            result = (Map)resultMap.getBody();
        }
        catch (RestClientException e) {
            LOGGER.error("Couldn't post the response excel: " + filePath, (Throwable)e);
            throw e;
        }
        LOGGER.info("POST FILE response: " + result);
        return result;
    }
}

