/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.egov.dataupload.property.models.Role;
import org.springframework.validation.annotation.Validated;

@Validated
public class User {
    @JsonProperty(value="id")
    private Long id;
    @Size(max=64)
    @JsonProperty(value="uuid")
    private String uuid;
    @Size(max=64)
    @JsonProperty(value="userName")
    private String userName;
    @Size(max=64)
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="salutation")
    private String salutation;
    @NotNull
    @Size(max=100)
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="gender")
    private String gender;
    @Pattern(regexp="^[0-9]{10}$", message="MobileNumber should be 10 digit number")
    @JsonProperty(value="mobileNumber")
    private String mobileNumber;
    @Size(max=128)
    @JsonProperty(value="emailId")
    private String emailId;
    @Size(max=50)
    @JsonProperty(value="altContactNumber")
    private String altContactNumber;
    @Size(max=10)
    @JsonProperty(value="pan")
    private String pan;
    @Pattern(regexp="^[0-9]{12}$", message="AdharNumber should be 12 digit number")
    @JsonProperty(value="aadhaarNumber")
    private String aadhaarNumber;
    @Size(max=300)
    @JsonProperty(value="permanentAddress")
    private String permanentAddress;
    @Size(max=300)
    @JsonProperty(value="permanentCity")
    private String permanentCity;
    @Size(max=10)
    @JsonProperty(value="permanentPinCode")
    private String permanentPincode;
    @Size(max=300)
    @JsonProperty(value="correspondenceCity")
    private String correspondenceCity;
    @Size(max=10)
    @JsonProperty(value="correspondencePinCode")
    private String correspondencePincode;
    @Size(max=300)
    @JsonProperty(value="correspondenceAddress")
    private String correspondenceAddress;
    @JsonProperty(value="active")
    private Boolean active;
    @JsonProperty(value="dob")
    private Long dob;
    @JsonProperty(value="pwdExpiryDate")
    private Long pwdExpiryDate;
    @Size(max=16)
    @JsonProperty(value="locale")
    private String locale;
    @Size(max=50)
    @JsonProperty(value="type")
    private String type;
    @Size(max=36)
    @JsonProperty(value="signature")
    private String signature;
    @JsonProperty(value="accountLocked")
    private Boolean accountLocked;
    @JsonProperty(value="roles")
    @Valid
    private List<Role> roles;
    @Size(max=100)
    @JsonProperty(value="fatherOrHusbandName")
    private String fatherOrHusbandName;
    @Size(max=32)
    @JsonProperty(value="bloodGroup")
    private String bloodGroup;
    @Size(max=300)
    @JsonProperty(value="identificationMark")
    private String identificationMark;
    @Size(max=36)
    @JsonProperty(value="photo")
    private String photo;
    @Size(max=64)
    @JsonProperty(value="createdBy")
    private String createdBy;
    @JsonProperty(value="createdDate")
    private Long createdDate;
    @Size(max=64)
    @JsonProperty(value="lastModifiedBy")
    private String lastModifiedBy;
    @JsonProperty(value="lastModifiedDate")
    private Long lastModifiedDate;
    @JsonProperty(value="otpReference")
    private String otpReference;
    @Size(max=256)
    @JsonProperty(value="tenantId")
    private String tenantId;

    public User addRolesItem(Role rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.add(rolesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.uuid, user.uuid) && Objects.equals(this.name, user.name) && Objects.equals(this.mobileNumber, user.mobileNumber);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name, this.mobileNumber);
    }

    public Long getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public String getPan() {
        return this.pan;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public String getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getPermanentCity() {
        return this.permanentCity;
    }

    public String getPermanentPincode() {
        return this.permanentPincode;
    }

    public String getCorrespondenceCity() {
        return this.correspondenceCity;
    }

    public String getCorrespondencePincode() {
        return this.correspondencePincode;
    }

    public String getCorrespondenceAddress() {
        return this.correspondenceAddress;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Long getDob() {
        return this.dob;
    }

    public Long getPwdExpiryDate() {
        return this.pwdExpiryDate;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getType() {
        return this.type;
    }

    public String getSignature() {
        return this.signature;
    }

    public Boolean getAccountLocked() {
        return this.accountLocked;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public String getFatherOrHusbandName() {
        return this.fatherOrHusbandName;
    }

    public String getBloodGroup() {
        return this.bloodGroup;
    }

    public String getIdentificationMark() {
        return this.identificationMark;
    }

    public String getPhoto() {
        return this.photo;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getOtpReference() {
        return this.otpReference;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public void setAltContactNumber(String altContactNumber) {
        this.altContactNumber = altContactNumber;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public void setPermanentAddress(String permanentAddress) {
        this.permanentAddress = permanentAddress;
    }

    public void setPermanentCity(String permanentCity) {
        this.permanentCity = permanentCity;
    }

    public void setPermanentPincode(String permanentPincode) {
        this.permanentPincode = permanentPincode;
    }

    public void setCorrespondenceCity(String correspondenceCity) {
        this.correspondenceCity = correspondenceCity;
    }

    public void setCorrespondencePincode(String correspondencePincode) {
        this.correspondencePincode = correspondencePincode;
    }

    public void setCorrespondenceAddress(String correspondenceAddress) {
        this.correspondenceAddress = correspondenceAddress;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setDob(Long dob) {
        this.dob = dob;
    }

    public void setPwdExpiryDate(Long pwdExpiryDate) {
        this.pwdExpiryDate = pwdExpiryDate;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setAccountLocked(Boolean accountLocked) {
        this.accountLocked = accountLocked;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void setFatherOrHusbandName(String fatherOrHusbandName) {
        this.fatherOrHusbandName = fatherOrHusbandName;
    }

    public void setBloodGroup(String bloodGroup) {
        this.bloodGroup = bloodGroup;
    }

    public void setIdentificationMark(String identificationMark) {
        this.identificationMark = identificationMark;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setOtpReference(String otpReference) {
        this.otpReference = otpReference;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @ConstructorProperties(value={"id", "uuid", "userName", "password", "salutation", "name", "gender", "mobileNumber", "emailId", "altContactNumber", "pan", "aadhaarNumber", "permanentAddress", "permanentCity", "permanentPincode", "correspondenceCity", "correspondencePincode", "correspondenceAddress", "active", "dob", "pwdExpiryDate", "locale", "type", "signature", "accountLocked", "roles", "fatherOrHusbandName", "bloodGroup", "identificationMark", "photo", "createdBy", "createdDate", "lastModifiedBy", "lastModifiedDate", "otpReference", "tenantId"})
    public User(Long id, String uuid, String userName, String password, String salutation, String name, String gender, String mobileNumber, String emailId, String altContactNumber, String pan, String aadhaarNumber, String permanentAddress, String permanentCity, String permanentPincode, String correspondenceCity, String correspondencePincode, String correspondenceAddress, Boolean active, Long dob, Long pwdExpiryDate, String locale, String type, String signature, Boolean accountLocked, List<Role> roles, String fatherOrHusbandName, String bloodGroup, String identificationMark, String photo, String createdBy, Long createdDate, String lastModifiedBy, Long lastModifiedDate, String otpReference, String tenantId) {
        this.id = id;
        this.uuid = uuid;
        this.userName = userName;
        this.password = password;
        this.salutation = salutation;
        this.name = name;
        this.gender = gender;
        this.mobileNumber = mobileNumber;
        this.emailId = emailId;
        this.altContactNumber = altContactNumber;
        this.pan = pan;
        this.aadhaarNumber = aadhaarNumber;
        this.permanentAddress = permanentAddress;
        this.permanentCity = permanentCity;
        this.permanentPincode = permanentPincode;
        this.correspondenceCity = correspondenceCity;
        this.correspondencePincode = correspondencePincode;
        this.correspondenceAddress = correspondenceAddress;
        this.active = active;
        this.dob = dob;
        this.pwdExpiryDate = pwdExpiryDate;
        this.locale = locale;
        this.type = type;
        this.signature = signature;
        this.accountLocked = accountLocked;
        this.roles = roles;
        this.fatherOrHusbandName = fatherOrHusbandName;
        this.bloodGroup = bloodGroup;
        this.identificationMark = identificationMark;
        this.photo = photo;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.otpReference = otpReference;
        this.tenantId = tenantId;
    }

    public User() {
    }

    public String toString() {
        return "User(id=" + this.getId() + ", uuid=" + this.getUuid() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", salutation=" + this.getSalutation() + ", name=" + this.getName() + ", gender=" + this.getGender() + ", mobileNumber=" + this.getMobileNumber() + ", emailId=" + this.getEmailId() + ", altContactNumber=" + this.getAltContactNumber() + ", pan=" + this.getPan() + ", aadhaarNumber=" + this.getAadhaarNumber() + ", permanentAddress=" + this.getPermanentAddress() + ", permanentCity=" + this.getPermanentCity() + ", permanentPincode=" + this.getPermanentPincode() + ", correspondenceCity=" + this.getCorrespondenceCity() + ", correspondencePincode=" + this.getCorrespondencePincode() + ", correspondenceAddress=" + this.getCorrespondenceAddress() + ", active=" + this.getActive() + ", dob=" + this.getDob() + ", pwdExpiryDate=" + this.getPwdExpiryDate() + ", locale=" + this.getLocale() + ", type=" + this.getType() + ", signature=" + this.getSignature() + ", accountLocked=" + this.getAccountLocked() + ", roles=" + this.getRoles() + ", fatherOrHusbandName=" + this.getFatherOrHusbandName() + ", bloodGroup=" + this.getBloodGroup() + ", identificationMark=" + this.getIdentificationMark() + ", photo=" + this.getPhoto() + ", createdBy=" + this.getCreatedBy() + ", createdDate=" + this.getCreatedDate() + ", lastModifiedBy=" + this.getLastModifiedBy() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", otpReference=" + this.getOtpReference() + ", tenantId=" + this.getTenantId() + ")";
    }
}

