/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.dataupload.property.models.Property;
import org.egov.dataupload.property.models.PropertyRequest;
import org.springframework.validation.annotation.Validated;

@Validated
public class PropertyRequest {
    @NotNull
    @JsonProperty(value="RequestInfo")
    private RequestInfo requestInfo;
    @JsonProperty(value="Properties")
    @Valid
    @NotNull
    @Size(min=1)
    private List<Property> properties;

    public PropertyRequest addPropertiesItem(Property propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    public static PropertyRequestBuilder builder() {
        return new PropertyRequestBuilder();
    }

    public String toString() {
        return "PropertyRequest(requestInfo=" + this.getRequestInfo() + ", properties=" + this.getProperties() + ")";
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @ConstructorProperties(value={"requestInfo", "properties"})
    public PropertyRequest(RequestInfo requestInfo, List<Property> properties) {
        this.requestInfo = requestInfo;
        this.properties = properties;
    }

    public PropertyRequest() {
    }
}

