/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.dataupload.property.models.AuditDetails;
import org.egov.dataupload.property.models.Calculation;
import org.egov.dataupload.property.models.Document;
import org.egov.dataupload.property.models.Institution;
import org.egov.dataupload.property.models.OwnerInfo;
import org.egov.dataupload.property.models.PropertyDetail;
import org.egov.dataupload.property.models.Unit;
import org.springframework.validation.annotation.Validated;

@Validated
public class PropertyDetail {
    @JsonProperty(value="institution")
    private Institution institution;
    @Size(max=256)
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="citizenInfo")
    private OwnerInfo citizenInfo = null;
    @JsonProperty(value="source")
    private SourceEnum source;
    @Size(max=64)
    @JsonProperty(value="usage")
    private String usage;
    @JsonProperty(value="noOfFloors")
    private Long noOfFloors;
    @JsonProperty(value="landArea")
    private Float landArea;
    @JsonProperty(value="buildUpArea")
    private Float buildUpArea;
    @JsonProperty(value="units")
    private List<Unit> units = new ArrayList();
    @JsonProperty(value="documents")
    @Valid
    private Set<Document> documents;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails;
    @NotNull
    @Size(max=64)
    @JsonProperty(value="financialYear")
    private String financialYear;
    @Size(max=64)
    @JsonProperty(value="propertyType")
    private String propertyType;
    @Size(max=64)
    @JsonProperty(value="propertySubType")
    private String propertySubType;
    @Size(max=64)
    @JsonProperty(value="assessmentNumber")
    private String assessmentNumber;
    @JsonProperty(value="assessmentDate")
    private Long assessmentDate;
    @Size(max=64)
    @JsonProperty(value="usageCategoryMajor")
    private String usageCategoryMajor;
    @Size(max=64)
    @JsonProperty(value="usageCategoryMinor")
    private String usageCategoryMinor;
    @Size(max=64)
    @JsonProperty(value="ownershipCategory")
    private String ownershipCategory;
    @Size(max=64)
    @JsonProperty(value="subOwnershipCategory")
    private String subOwnershipCategory;
    @JsonProperty(value="adhocExemption")
    private BigDecimal adhocExemption;
    @JsonProperty(value="adhocPenalty")
    private BigDecimal adhocPenalty;
    @Size(max=1024)
    @JsonProperty(value="adhocExemptionReason")
    private String adhocExemptionReason;
    @Size(max=1024)
    @JsonProperty(value="adhocPenaltyReason")
    private String adhocPenaltyReason;
    @JsonProperty(value="owners")
    @Valid
    @NotNull
    @Size(min=1)
    private Set<OwnerInfo> owners = new HashSet();
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;
    @JsonProperty(value="calculation")
    private Calculation calculation;
    @JsonProperty(value="channel")
    private ChannelEnum channel;

    public PropertyDetail addUnitsItem(Unit unitsItem) {
        if (this.units == null) {
            this.units = new ArrayList();
        }
        if (!this.units.contains(unitsItem)) {
            this.units.add(unitsItem);
        }
        return this;
    }

    public PropertyDetail addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new HashSet();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public PropertyDetail addOwnersItem(OwnerInfo ownersItem) {
        if (this.owners == null) {
            this.owners = new HashSet();
        }
        this.owners.add(ownersItem);
        return this;
    }

    public static PropertyDetailBuilder builder() {
        return new PropertyDetailBuilder();
    }

    public Institution getInstitution() {
        return this.institution;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public OwnerInfo getCitizenInfo() {
        return this.citizenInfo;
    }

    public SourceEnum getSource() {
        return this.source;
    }

    public String getUsage() {
        return this.usage;
    }

    public Long getNoOfFloors() {
        return this.noOfFloors;
    }

    public Float getLandArea() {
        return this.landArea;
    }

    public Float getBuildUpArea() {
        return this.buildUpArea;
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public Set<Document> getDocuments() {
        return this.documents;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String getFinancialYear() {
        return this.financialYear;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getPropertySubType() {
        return this.propertySubType;
    }

    public String getAssessmentNumber() {
        return this.assessmentNumber;
    }

    public Long getAssessmentDate() {
        return this.assessmentDate;
    }

    public String getUsageCategoryMajor() {
        return this.usageCategoryMajor;
    }

    public String getUsageCategoryMinor() {
        return this.usageCategoryMinor;
    }

    public String getOwnershipCategory() {
        return this.ownershipCategory;
    }

    public String getSubOwnershipCategory() {
        return this.subOwnershipCategory;
    }

    public BigDecimal getAdhocExemption() {
        return this.adhocExemption;
    }

    public BigDecimal getAdhocPenalty() {
        return this.adhocPenalty;
    }

    public String getAdhocExemptionReason() {
        return this.adhocExemptionReason;
    }

    public String getAdhocPenaltyReason() {
        return this.adhocPenaltyReason;
    }

    public Set<OwnerInfo> getOwners() {
        return this.owners;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Calculation getCalculation() {
        return this.calculation;
    }

    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setCitizenInfo(OwnerInfo citizenInfo) {
        this.citizenInfo = citizenInfo;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setNoOfFloors(Long noOfFloors) {
        this.noOfFloors = noOfFloors;
    }

    public void setLandArea(Float landArea) {
        this.landArea = landArea;
    }

    public void setBuildUpArea(Float buildUpArea) {
        this.buildUpArea = buildUpArea;
    }

    public void setUnits(List<Unit> units) {
        this.units = units;
    }

    public void setDocuments(Set<Document> documents) {
        this.documents = documents;
    }

    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public void setFinancialYear(String financialYear) {
        this.financialYear = financialYear;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public void setPropertySubType(String propertySubType) {
        this.propertySubType = propertySubType;
    }

    public void setAssessmentNumber(String assessmentNumber) {
        this.assessmentNumber = assessmentNumber;
    }

    public void setAssessmentDate(Long assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public void setUsageCategoryMajor(String usageCategoryMajor) {
        this.usageCategoryMajor = usageCategoryMajor;
    }

    public void setUsageCategoryMinor(String usageCategoryMinor) {
        this.usageCategoryMinor = usageCategoryMinor;
    }

    public void setOwnershipCategory(String ownershipCategory) {
        this.ownershipCategory = ownershipCategory;
    }

    public void setSubOwnershipCategory(String subOwnershipCategory) {
        this.subOwnershipCategory = subOwnershipCategory;
    }

    public void setAdhocExemption(BigDecimal adhocExemption) {
        this.adhocExemption = adhocExemption;
    }

    public void setAdhocPenalty(BigDecimal adhocPenalty) {
        this.adhocPenalty = adhocPenalty;
    }

    public void setAdhocExemptionReason(String adhocExemptionReason) {
        this.adhocExemptionReason = adhocExemptionReason;
    }

    public void setAdhocPenaltyReason(String adhocPenaltyReason) {
        this.adhocPenaltyReason = adhocPenaltyReason;
    }

    public void setOwners(Set<OwnerInfo> owners) {
        this.owners = owners;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public void setCalculation(Calculation calculation) {
        this.calculation = calculation;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    @ConstructorProperties(value={"institution", "tenantId", "citizenInfo", "source", "usage", "noOfFloors", "landArea", "buildUpArea", "units", "documents", "additionalDetails", "financialYear", "propertyType", "propertySubType", "assessmentNumber", "assessmentDate", "usageCategoryMajor", "usageCategoryMinor", "ownershipCategory", "subOwnershipCategory", "adhocExemption", "adhocPenalty", "adhocExemptionReason", "adhocPenaltyReason", "owners", "auditDetails", "calculation", "channel"})
    public PropertyDetail(Institution institution, String tenantId, OwnerInfo citizenInfo, SourceEnum source, String usage, Long noOfFloors, Float landArea, Float buildUpArea, List<Unit> units, Set<Document> documents, Object additionalDetails, String financialYear, String propertyType, String propertySubType, String assessmentNumber, Long assessmentDate, String usageCategoryMajor, String usageCategoryMinor, String ownershipCategory, String subOwnershipCategory, BigDecimal adhocExemption, BigDecimal adhocPenalty, String adhocExemptionReason, String adhocPenaltyReason, Set<OwnerInfo> owners, AuditDetails auditDetails, Calculation calculation, ChannelEnum channel) {
        this.institution = institution;
        this.tenantId = tenantId;
        this.citizenInfo = citizenInfo;
        this.source = source;
        this.usage = usage;
        this.noOfFloors = noOfFloors;
        this.landArea = landArea;
        this.buildUpArea = buildUpArea;
        this.units = units;
        this.documents = documents;
        this.additionalDetails = additionalDetails;
        this.financialYear = financialYear;
        this.propertyType = propertyType;
        this.propertySubType = propertySubType;
        this.assessmentNumber = assessmentNumber;
        this.assessmentDate = assessmentDate;
        this.usageCategoryMajor = usageCategoryMajor;
        this.usageCategoryMinor = usageCategoryMinor;
        this.ownershipCategory = ownershipCategory;
        this.subOwnershipCategory = subOwnershipCategory;
        this.adhocExemption = adhocExemption;
        this.adhocPenalty = adhocPenalty;
        this.adhocExemptionReason = adhocExemptionReason;
        this.adhocPenaltyReason = adhocPenaltyReason;
        this.owners = owners;
        this.auditDetails = auditDetails;
        this.calculation = calculation;
        this.channel = channel;
    }

    public PropertyDetail() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDetail)) {
            return false;
        }
        PropertyDetail other = (PropertyDetail)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Institution this$institution = this.getInstitution();
        Institution other$institution = other.getInstitution();
        if (this$institution == null ? other$institution != null : !this$institution.equals(other$institution)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        OwnerInfo this$citizenInfo = this.getCitizenInfo();
        OwnerInfo other$citizenInfo = other.getCitizenInfo();
        if (this$citizenInfo == null ? other$citizenInfo != null : !this$citizenInfo.equals(other$citizenInfo)) {
            return false;
        }
        SourceEnum this$source = this.getSource();
        SourceEnum other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Long this$noOfFloors = this.getNoOfFloors();
        Long other$noOfFloors = other.getNoOfFloors();
        if (this$noOfFloors == null ? other$noOfFloors != null : !((Object)this$noOfFloors).equals(other$noOfFloors)) {
            return false;
        }
        Float this$landArea = this.getLandArea();
        Float other$landArea = other.getLandArea();
        if (this$landArea == null ? other$landArea != null : !((Object)this$landArea).equals(other$landArea)) {
            return false;
        }
        Float this$buildUpArea = this.getBuildUpArea();
        Float other$buildUpArea = other.getBuildUpArea();
        if (this$buildUpArea == null ? other$buildUpArea != null : !((Object)this$buildUpArea).equals(other$buildUpArea)) {
            return false;
        }
        List this$units = this.getUnits();
        List other$units = other.getUnits();
        if (this$units == null ? other$units != null : !((Object)this$units).equals(other$units)) {
            return false;
        }
        Set this$documents = this.getDocuments();
        Set other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        String this$financialYear = this.getFinancialYear();
        String other$financialYear = other.getFinancialYear();
        if (this$financialYear == null ? other$financialYear != null : !this$financialYear.equals(other$financialYear)) {
            return false;
        }
        String this$propertyType = this.getPropertyType();
        String other$propertyType = other.getPropertyType();
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        String this$propertySubType = this.getPropertySubType();
        String other$propertySubType = other.getPropertySubType();
        if (this$propertySubType == null ? other$propertySubType != null : !this$propertySubType.equals(other$propertySubType)) {
            return false;
        }
        String this$assessmentNumber = this.getAssessmentNumber();
        String other$assessmentNumber = other.getAssessmentNumber();
        if (this$assessmentNumber == null ? other$assessmentNumber != null : !this$assessmentNumber.equals(other$assessmentNumber)) {
            return false;
        }
        Long this$assessmentDate = this.getAssessmentDate();
        Long other$assessmentDate = other.getAssessmentDate();
        if (this$assessmentDate == null ? other$assessmentDate != null : !((Object)this$assessmentDate).equals(other$assessmentDate)) {
            return false;
        }
        String this$usageCategoryMajor = this.getUsageCategoryMajor();
        String other$usageCategoryMajor = other.getUsageCategoryMajor();
        if (this$usageCategoryMajor == null ? other$usageCategoryMajor != null : !this$usageCategoryMajor.equals(other$usageCategoryMajor)) {
            return false;
        }
        String this$usageCategoryMinor = this.getUsageCategoryMinor();
        String other$usageCategoryMinor = other.getUsageCategoryMinor();
        if (this$usageCategoryMinor == null ? other$usageCategoryMinor != null : !this$usageCategoryMinor.equals(other$usageCategoryMinor)) {
            return false;
        }
        String this$ownershipCategory = this.getOwnershipCategory();
        String other$ownershipCategory = other.getOwnershipCategory();
        if (this$ownershipCategory == null ? other$ownershipCategory != null : !this$ownershipCategory.equals(other$ownershipCategory)) {
            return false;
        }
        String this$subOwnershipCategory = this.getSubOwnershipCategory();
        String other$subOwnershipCategory = other.getSubOwnershipCategory();
        if (this$subOwnershipCategory == null ? other$subOwnershipCategory != null : !this$subOwnershipCategory.equals(other$subOwnershipCategory)) {
            return false;
        }
        BigDecimal this$adhocExemption = this.getAdhocExemption();
        BigDecimal other$adhocExemption = other.getAdhocExemption();
        if (this$adhocExemption == null ? other$adhocExemption != null : !((Object)this$adhocExemption).equals(other$adhocExemption)) {
            return false;
        }
        BigDecimal this$adhocPenalty = this.getAdhocPenalty();
        BigDecimal other$adhocPenalty = other.getAdhocPenalty();
        if (this$adhocPenalty == null ? other$adhocPenalty != null : !((Object)this$adhocPenalty).equals(other$adhocPenalty)) {
            return false;
        }
        String this$adhocExemptionReason = this.getAdhocExemptionReason();
        String other$adhocExemptionReason = other.getAdhocExemptionReason();
        if (this$adhocExemptionReason == null ? other$adhocExemptionReason != null : !this$adhocExemptionReason.equals(other$adhocExemptionReason)) {
            return false;
        }
        String this$adhocPenaltyReason = this.getAdhocPenaltyReason();
        String other$adhocPenaltyReason = other.getAdhocPenaltyReason();
        if (this$adhocPenaltyReason == null ? other$adhocPenaltyReason != null : !this$adhocPenaltyReason.equals(other$adhocPenaltyReason)) {
            return false;
        }
        Set this$owners = this.getOwners();
        Set other$owners = other.getOwners();
        if (this$owners == null ? other$owners != null : !((Object)this$owners).equals(other$owners)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Calculation this$calculation = this.getCalculation();
        Calculation other$calculation = other.getCalculation();
        if (this$calculation == null ? other$calculation != null : !this$calculation.equals(other$calculation)) {
            return false;
        }
        ChannelEnum this$channel = this.getChannel();
        ChannelEnum other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Institution $institution = this.getInstitution();
        result = result * 59 + ($institution == null ? 43 : $institution.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        OwnerInfo $citizenInfo = this.getCitizenInfo();
        result = result * 59 + ($citizenInfo == null ? 43 : $citizenInfo.hashCode());
        SourceEnum $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Long $noOfFloors = this.getNoOfFloors();
        result = result * 59 + ($noOfFloors == null ? 43 : ((Object)$noOfFloors).hashCode());
        Float $landArea = this.getLandArea();
        result = result * 59 + ($landArea == null ? 43 : ((Object)$landArea).hashCode());
        Float $buildUpArea = this.getBuildUpArea();
        result = result * 59 + ($buildUpArea == null ? 43 : ((Object)$buildUpArea).hashCode());
        List $units = this.getUnits();
        result = result * 59 + ($units == null ? 43 : ((Object)$units).hashCode());
        Set $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        String $financialYear = this.getFinancialYear();
        result = result * 59 + ($financialYear == null ? 43 : $financialYear.hashCode());
        String $propertyType = this.getPropertyType();
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        String $propertySubType = this.getPropertySubType();
        result = result * 59 + ($propertySubType == null ? 43 : $propertySubType.hashCode());
        String $assessmentNumber = this.getAssessmentNumber();
        result = result * 59 + ($assessmentNumber == null ? 43 : $assessmentNumber.hashCode());
        Long $assessmentDate = this.getAssessmentDate();
        result = result * 59 + ($assessmentDate == null ? 43 : ((Object)$assessmentDate).hashCode());
        String $usageCategoryMajor = this.getUsageCategoryMajor();
        result = result * 59 + ($usageCategoryMajor == null ? 43 : $usageCategoryMajor.hashCode());
        String $usageCategoryMinor = this.getUsageCategoryMinor();
        result = result * 59 + ($usageCategoryMinor == null ? 43 : $usageCategoryMinor.hashCode());
        String $ownershipCategory = this.getOwnershipCategory();
        result = result * 59 + ($ownershipCategory == null ? 43 : $ownershipCategory.hashCode());
        String $subOwnershipCategory = this.getSubOwnershipCategory();
        result = result * 59 + ($subOwnershipCategory == null ? 43 : $subOwnershipCategory.hashCode());
        BigDecimal $adhocExemption = this.getAdhocExemption();
        result = result * 59 + ($adhocExemption == null ? 43 : ((Object)$adhocExemption).hashCode());
        BigDecimal $adhocPenalty = this.getAdhocPenalty();
        result = result * 59 + ($adhocPenalty == null ? 43 : ((Object)$adhocPenalty).hashCode());
        String $adhocExemptionReason = this.getAdhocExemptionReason();
        result = result * 59 + ($adhocExemptionReason == null ? 43 : $adhocExemptionReason.hashCode());
        String $adhocPenaltyReason = this.getAdhocPenaltyReason();
        result = result * 59 + ($adhocPenaltyReason == null ? 43 : $adhocPenaltyReason.hashCode());
        Set $owners = this.getOwners();
        result = result * 59 + ($owners == null ? 43 : ((Object)$owners).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Calculation $calculation = this.getCalculation();
        result = result * 59 + ($calculation == null ? 43 : $calculation.hashCode());
        ChannelEnum $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    public String toString() {
        return "PropertyDetail(institution=" + this.getInstitution() + ", tenantId=" + this.getTenantId() + ", citizenInfo=" + this.getCitizenInfo() + ", source=" + this.getSource() + ", usage=" + this.getUsage() + ", noOfFloors=" + this.getNoOfFloors() + ", landArea=" + this.getLandArea() + ", buildUpArea=" + this.getBuildUpArea() + ", units=" + this.getUnits() + ", documents=" + this.getDocuments() + ", additionalDetails=" + this.getAdditionalDetails() + ", financialYear=" + this.getFinancialYear() + ", propertyType=" + this.getPropertyType() + ", propertySubType=" + this.getPropertySubType() + ", assessmentNumber=" + this.getAssessmentNumber() + ", assessmentDate=" + this.getAssessmentDate() + ", usageCategoryMajor=" + this.getUsageCategoryMajor() + ", usageCategoryMinor=" + this.getUsageCategoryMinor() + ", ownershipCategory=" + this.getOwnershipCategory() + ", subOwnershipCategory=" + this.getSubOwnershipCategory() + ", adhocExemption=" + this.getAdhocExemption() + ", adhocPenalty=" + this.getAdhocPenalty() + ", adhocExemptionReason=" + this.getAdhocExemptionReason() + ", adhocPenaltyReason=" + this.getAdhocPenaltyReason() + ", owners=" + this.getOwners() + ", auditDetails=" + this.getAuditDetails() + ", calculation=" + this.getCalculation() + ", channel=" + this.getChannel() + ")";
    }
}

