/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.egov.dataupload.property.models.Address;
import org.egov.dataupload.property.models.AuditDetails;
import org.egov.dataupload.property.models.Property;
import org.egov.dataupload.property.models.PropertyDetail;
import org.egov.dataupload.property.models.PropertyInfo;
import org.springframework.validation.annotation.Validated;

@Validated
public class Property
extends PropertyInfo {
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;
    @JsonProperty(value="creationReason")
    private CreationReasonEnum creationReason;
    @JsonProperty(value="occupancyDate")
    private Long occupancyDate;
    @Valid
    @JsonProperty(value="propertyDetails")
    private List<PropertyDetail> propertyDetails = Arrays.asList(new PropertyDetail());

    public Property addpropertyDetailsItem(PropertyDetail propertyDetailsItem) {
        if (this.propertyDetails == null) {
            this.propertyDetails = new ArrayList();
        }
        this.propertyDetails.add(propertyDetailsItem);
        return this;
    }

    public Property(String propertyId, String tenantId, String acknowldgementNumber, String oldPropertyId, PropertyInfo.StatusEnum status, Address address, AuditDetails auditDetails, CreationReasonEnum creationReason, Long occupancyDate, List<PropertyDetail> propertyDetails) {
        super(propertyId, tenantId, acknowldgementNumber, oldPropertyId, status, address);
        this.auditDetails = auditDetails;
        this.creationReason = creationReason;
        this.occupancyDate = occupancyDate;
        this.propertyDetails = propertyDetails;
    }

    public static PropertyBuilder builder() {
        return new PropertyBuilder();
    }

    public String toString() {
        return "Property(auditDetails=" + this.getAuditDetails() + ", creationReason=" + this.getCreationReason() + ", occupancyDate=" + this.getOccupancyDate() + ", propertyDetails=" + this.getPropertyDetails() + ")";
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public CreationReasonEnum getCreationReason() {
        return this.creationReason;
    }

    public Long getOccupancyDate() {
        return this.occupancyDate;
    }

    public List<PropertyDetail> getPropertyDetails() {
        return this.propertyDetails;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public void setCreationReason(CreationReasonEnum creationReason) {
        this.creationReason = creationReason;
    }

    public void setOccupancyDate(Long occupancyDate) {
        this.occupancyDate = occupancyDate;
    }

    public void setPropertyDetails(List<PropertyDetail> propertyDetails) {
        this.propertyDetails = propertyDetails;
    }

    @ConstructorProperties(value={"auditDetails", "creationReason", "occupancyDate", "propertyDetails"})
    public Property(AuditDetails auditDetails, CreationReasonEnum creationReason, Long occupancyDate, List<PropertyDetail> propertyDetails) {
        this.auditDetails = auditDetails;
        this.creationReason = creationReason;
        this.occupancyDate = occupancyDate;
        this.propertyDetails = propertyDetails;
    }

    public Property() {
    }
}

