/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.egov.dataupload.property.models.Document;
import org.egov.dataupload.property.models.OwnerInfo;
import org.egov.dataupload.property.models.Role;
import org.egov.dataupload.property.models.User;
import org.springframework.validation.annotation.Validated;

@Validated
public class OwnerInfo
extends User {
    @JsonProperty(value="isPrimaryOwner")
    private Boolean isPrimaryOwner;
    @JsonProperty(value="ownerShipPercentage")
    private Double ownerShipPercentage;
    @Size(max=64)
    @JsonProperty(value="ownerType")
    private String ownerType;
    @Size(max=64)
    @JsonProperty(value="institutionId")
    private String institutionId;
    @JsonProperty(value="documents")
    @Valid
    private Set<Document> documents;
    @JsonProperty(value="relationship")
    private RelationshipEnum relationship;

    public OwnerInfo(Long id, String uuid, String userName, String password, String salutation, String name, String gender, String mobileNumber, String emailId, String altContactNumber, String pan, String aadhaarNumber, String permanentAddress, String permanentCity, String permanentPincode, String correspondenceCity, String correspondencePincode, String correspondenceAddress, Boolean active, Long dob, Long pwdExpiryDate, String locale, String type, String signature, Boolean accountLocked, List<Role> roles, String fatherOrHusbandName, String bloodGroup, String identificationMark, String photo, String createdBy, Long createdDate, String lastModifiedBy, Long lastModifiedDate, String otpReference, String tenantId, Boolean isPrimaryOwner, Double ownerShipPercentage, String ownerType, String institutionId, Set<Document> documents, RelationshipEnum relationship) {
        super(id, uuid, userName, password, salutation, name, gender, mobileNumber, emailId, altContactNumber, pan, aadhaarNumber, permanentAddress, permanentCity, permanentPincode, correspondenceCity, correspondencePincode, correspondenceAddress, active, dob, pwdExpiryDate, locale, type, signature, accountLocked, roles, fatherOrHusbandName, bloodGroup, identificationMark, photo, createdBy, createdDate, lastModifiedBy, lastModifiedDate, otpReference, tenantId);
        this.isPrimaryOwner = isPrimaryOwner;
        this.ownerShipPercentage = ownerShipPercentage;
        this.ownerType = ownerType;
        this.relationship = relationship;
        this.institutionId = institutionId;
        this.documents = documents;
    }

    public OwnerInfo addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new HashSet();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public void addUserDetail(User user) {
        this.setLastModifiedDate(user.getLastModifiedDate());
        this.setLastModifiedBy(user.getLastModifiedBy());
        this.setCreatedBy(user.getCreatedBy());
        this.setCreatedDate(user.getCreatedDate());
        this.setUserName(user.getUserName());
        this.setPassword(user.getPassword());
        this.setSalutation(user.getSalutation());
        this.setName(user.getName());
        this.setGender(user.getGender());
        this.setMobileNumber(user.getMobileNumber());
        this.setEmailId(user.getEmailId());
        this.setAltContactNumber(user.getAltContactNumber());
        this.setPan(user.getPan());
        this.setAadhaarNumber(user.getAadhaarNumber());
        this.setPermanentAddress(user.getPermanentAddress());
        this.setPermanentCity(user.getPermanentCity());
        this.setPermanentPincode(user.getPermanentPincode());
        this.setCorrespondenceAddress(user.getCorrespondenceAddress());
        this.setCorrespondenceCity(user.getCorrespondenceCity());
        this.setCorrespondencePincode(user.getCorrespondencePincode());
        this.setActive(user.getActive());
        this.setDob(user.getDob());
        this.setPwdExpiryDate(user.getPwdExpiryDate());
        this.setLocale(user.getLocale());
        this.setType(user.getType());
        this.setAccountLocked(user.getAccountLocked());
        this.setRoles(user.getRoles());
        this.setFatherOrHusbandName(user.getFatherOrHusbandName());
        this.setBloodGroup(user.getBloodGroup());
        this.setIdentificationMark(user.getIdentificationMark());
        this.setPhoto(user.getPhoto());
        this.setTenantId(user.getTenantId());
    }

    public OwnerInfo(User user) {
        this.setTenantId(user.getTenantId());
        this.setUserName(user.getUserName());
        this.setId(user.getId());
        this.setName(user.getName());
        this.setType(user.getType());
        this.setMobileNumber(user.getMobileNumber());
        this.setEmailId(user.getEmailId());
        this.setRoles(this.addRoles(user.getRoles()));
        this.setUuid(user.getUuid());
    }

    public void addCitizenDetail(User user) {
        this.setTenantId(user.getTenantId());
        this.setUserName(user.getUserName());
        this.setId(user.getId());
        this.setName(user.getName());
        this.setType(user.getType());
        this.setMobileNumber(user.getMobileNumber());
        this.setEmailId(user.getEmailId());
        this.setRoles(user.getRoles());
        this.setUuid(user.getUuid());
    }

    private List<Role> addRoles(List<Role> Roles) {
        LinkedList<Role> addroles = new LinkedList<Role>();
        Roles.forEach(role -> {
            Role addrole = new Role();
            addrole.setId(role.getId());
            addrole.setName(role.getName());
            addrole.setCode(role.getCode());
            addroles.add(addrole);
        });
        return addroles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.getUuid(), user.getUuid()) && Objects.equals(this.getName(), user.getName()) && Objects.equals(this.getMobileNumber(), user.getMobileNumber());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static OwnerInfoBuilder builder() {
        return new OwnerInfoBuilder();
    }

    public Boolean getIsPrimaryOwner() {
        return this.isPrimaryOwner;
    }

    public Double getOwnerShipPercentage() {
        return this.ownerShipPercentage;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public Set<Document> getDocuments() {
        return this.documents;
    }

    public RelationshipEnum getRelationship() {
        return this.relationship;
    }

    public void setIsPrimaryOwner(Boolean isPrimaryOwner) {
        this.isPrimaryOwner = isPrimaryOwner;
    }

    public void setOwnerShipPercentage(Double ownerShipPercentage) {
        this.ownerShipPercentage = ownerShipPercentage;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public void setDocuments(Set<Document> documents) {
        this.documents = documents;
    }

    public void setRelationship(RelationshipEnum relationship) {
        this.relationship = relationship;
    }

    @ConstructorProperties(value={"isPrimaryOwner", "ownerShipPercentage", "ownerType", "institutionId", "documents", "relationship"})
    public OwnerInfo(Boolean isPrimaryOwner, Double ownerShipPercentage, String ownerType, String institutionId, Set<Document> documents, RelationshipEnum relationship) {
        this.isPrimaryOwner = isPrimaryOwner;
        this.ownerShipPercentage = ownerShipPercentage;
        this.ownerType = ownerType;
        this.institutionId = institutionId;
        this.documents = documents;
        this.relationship = relationship;
    }

    public OwnerInfo() {
    }

    public String toString() {
        return "OwnerInfo(isPrimaryOwner=" + this.getIsPrimaryOwner() + ", ownerShipPercentage=" + this.getOwnerShipPercentage() + ", ownerType=" + this.getOwnerType() + ", institutionId=" + this.getInstitutionId() + ", documents=" + this.getDocuments() + ", relationship=" + this.getRelationship() + ")";
    }
}

