/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.property;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.egov.dataupload.property.models.Document;
import org.egov.dataupload.property.models.OwnerInfo;
import org.egov.dataupload.property.models.Property;
import org.egov.dataupload.property.models.PropertyDetail;
import org.egov.dataupload.property.models.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PropertyFileReader {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileReader.class);

    public Map<String, Sheet> readFile(String location) throws InvalidFormatException, IOException {
        HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>();
        Workbook workbook = WorkbookFactory.create((File)new File(location));
        log.info("Workbook has " + workbook.getNumberOfSheets() + " Sheets : ");
        workbook.forEach(sheet -> {
            log.info("=> " + sheet.getSheetName());
            sheetMap.put(sheet.getSheetName(), (Sheet)sheet);
        });
        workbook.close();
        return sheetMap;
    }

    public Map<String, Property> parseExcel(String location) throws EncryptedDocumentException, InvalidFormatException, IOException {
        Map sheetMap = this.readFile(location);
        Map propertyIdMap = this.parsePropertyExcel(sheetMap);
        this.parseUnitDetail(sheetMap, propertyIdMap);
        this.parseOwnerDetail(sheetMap, propertyIdMap);
        return propertyIdMap;
    }

    public Map<String, Property> parsePropertyExcel(Map<String, Sheet> sheetMap) {
        Sheet propertySheet = sheetMap.get("Property_Detail");
        LinkedHashMap<String, Property> propertyIdMap = new LinkedHashMap<String, Property>();
        Iterator rowIterator = propertySheet.rowIterator();
        int rowNumber = 0;
        while (rowIterator.hasNext()) {
            Property property = new Property();
            ((PropertyDetail)property.getPropertyDetails().get(0)).setAdditionalDetails(new HashMap());
            Row row = (Row)rowIterator.next();
            if (rowNumber++ == 0) continue;
            if (StringUtils.isEmpty((Object)row.getCell(0))) break;
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                Cell cell = row.getCell(i);
                if (null == cell) continue;
                this.setPropertyDetails(cell, property);
            }
            if (StringUtils.isEmpty((Object)property.getOldPropertyId())) continue;
            if (null != propertyIdMap.get(property.getOldPropertyId())) {
                StringBuilder id = new StringBuilder();
                id.append("duplicate_").append(property.getOldPropertyId()).append("_").append(rowNumber);
                propertyIdMap.put(id.toString(), property);
                continue;
            }
            propertyIdMap.put(property.getOldPropertyId(), property);
        }
        return propertyIdMap;
    }

    private void setPropertyDetails(Cell cell, Property property) {
        switch (cell.getColumnIndex()) {
            case 0: {
                property.setTenantId(cell.getStringCellValue());
                break;
            }
            case 1: {
                cell.setCellType(CellType.STRING);
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                property.getAddress().setCity(cell.getStringCellValue());
                break;
            }
            case 2: {
                property.setOldPropertyId(cell.getStringCellValue());
                break;
            }
            case 3: {
                ((PropertyDetail)property.getPropertyDetails().get(0)).setFinancialYear(cell.getStringCellValue());
                break;
            }
            case 4: {
                ((PropertyDetail)property.getPropertyDetails().get(0)).setPropertyType(cell.getStringCellValue());
                break;
            }
            case 5: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ((PropertyDetail)property.getPropertyDetails().get(0)).setPropertySubType(cell.getStringCellValue());
                break;
            }
            case 6: {
                Map addDetails = (Map)((PropertyDetail)property.getPropertyDetails().get(0)).getAdditionalDetails();
                addDetails.put("heightAbove36Feet", cell.getBooleanCellValue());
                break;
            }
            case 7: {
                Map addDetailsMap = (Map)((PropertyDetail)property.getPropertyDetails().get(0)).getAdditionalDetails();
                addDetailsMap.put("inflammable", cell.getBooleanCellValue());
                break;
            }
            case 8: {
                ((PropertyDetail)property.getPropertyDetails().get(0)).setUsageCategoryMajor(cell.getStringCellValue());
                break;
            }
            case 9: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ((PropertyDetail)property.getPropertyDetails().get(0)).setUsageCategoryMinor(cell.getStringCellValue());
                break;
            }
            case 10: {
                if (cell.getNumericCellValue() == 0.0) break;
                if ("SHAREDPROPERTY".equalsIgnoreCase(((PropertyDetail)property.getPropertyDetails().get(0)).getPropertySubType())) {
                    ((PropertyDetail)property.getPropertyDetails().get(0)).setBuildUpArea(Float.valueOf((float)cell.getNumericCellValue()));
                    break;
                }
                ((PropertyDetail)property.getPropertyDetails().get(0)).setLandArea(Float.valueOf((float)cell.getNumericCellValue()));
                break;
            }
            case 11: {
                if (cell.getNumericCellValue() == 0.0) break;
                ((PropertyDetail)property.getPropertyDetails().get(0)).setNoOfFloors(Long.valueOf((long)cell.getNumericCellValue()));
                break;
            }
            case 12: {
                ((PropertyDetail)property.getPropertyDetails().get(0)).setOwnershipCategory(cell.getStringCellValue());
                break;
            }
            case 13: {
                ((PropertyDetail)property.getPropertyDetails().get(0)).setSubOwnershipCategory(cell.getStringCellValue());
                break;
            }
            case 14: {
                property.getAddress().getLocality().setCode(cell.getStringCellValue());
                break;
            }
            case 15: {
                if (cell.getNumericCellValue() == 0.0 || StringUtils.isEmpty((Object)((int)cell.getNumericCellValue()))) break;
                property.getAddress().setDoorNo(String.valueOf((int)cell.getNumericCellValue()));
                break;
            }
            case 16: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                property.getAddress().setBuildingName(cell.getStringCellValue());
                break;
            }
            case 17: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                property.getAddress().setStreet(cell.getStringCellValue());
                break;
            }
            case 18: {
                if (cell.getNumericCellValue() == 0.0 || StringUtils.isEmpty((Object)((int)cell.getNumericCellValue()))) break;
                property.getAddress().setPincode(String.valueOf((int)cell.getNumericCellValue()));
                break;
            }
        }
        System.out.print("\t");
    }

    private void parseUnitDetail(Map<String, Sheet> sheetMap, Map<String, Property> propertyIdMap) {
        Sheet propertyUnitSheet = sheetMap.get("Unit_Detail");
        Iterator rowIterator = propertyUnitSheet.rowIterator();
        int rowNumber = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (rowNumber++ == 0) continue;
            if (StringUtils.isEmpty((Object)row.getCell(0))) break;
            String propertyId = row.getCell(1).getStringCellValue();
            Property property = propertyIdMap.get(propertyId);
            if (null == property) continue;
            Unit unit = new Unit();
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                Cell cell = row.getCell(i);
                if (null == cell) continue;
                this.setUnitDetails(cell, unit);
            }
            ((PropertyDetail)property.getPropertyDetails().get(0)).getUnits().add(unit);
        }
    }

    private void setUnitDetails(Cell cell, Unit unit) {
        switch (cell.getColumnIndex()) {
            case 0: {
                unit.setTenantId(cell.getStringCellValue());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                unit.setFloorNo(String.valueOf((int)cell.getNumericCellValue()));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                unit.setUsageCategoryMajor(cell.getStringCellValue());
                break;
            }
            case 5: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                unit.setUsageCategoryMinor(cell.getStringCellValue());
                break;
            }
            case 6: {
                unit.setOccupancyType(cell.getStringCellValue());
                break;
            }
            case 7: {
                if (cell.getNumericCellValue() == 0.0) break;
                unit.setUnitArea(Float.valueOf((float)cell.getNumericCellValue()));
                break;
            }
            case 8: {
                if (cell.getNumericCellValue() == 0.0) break;
                unit.setArv(new BigDecimal(cell.getNumericCellValue(), MathContext.DECIMAL64));
                break;
            }
            case 9: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                unit.setUsageCategorySubMinor(cell.getStringCellValue());
                break;
            }
            case 10: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                unit.setUsageCategoryDetail(cell.getStringCellValue());
                break;
            }
        }
        System.out.print("\t");
    }

    private void parseOwnerDetail(Map<String, Sheet> sheetMap, Map<String, Property> propertyIdMap) {
        Sheet propertyUnitSheet = sheetMap.get("Owner_Detail");
        Iterator rowIterator = propertyUnitSheet.rowIterator();
        int rowNumber = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (rowNumber++ == 0) continue;
            if (StringUtils.isEmpty((Object)row.getCell(0))) break;
            String propertyId = row.getCell(1).getStringCellValue();
            Property property = propertyIdMap.get(propertyId);
            if (null == property) continue;
            PropertyDetail dtl = (PropertyDetail)property.getPropertyDetails().get(0);
            OwnerInfo owner = new OwnerInfo();
            Document ownerDoc = new Document();
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                Cell cell = row.getCell(i);
                if (null == cell) continue;
                this.setOwnerDetails(cell, owner, ownerDoc);
            }
            HashSet<Document> docs = new HashSet<Document>();
            docs.add(ownerDoc);
            owner.setDocuments(docs);
            if (CollectionUtils.isEmpty((Collection)dtl.getOwners())) {
                dtl.setCitizenInfo(owner);
            }
            dtl.getOwners().add(owner);
        }
    }

    private void setOwnerDetails(Cell cell, OwnerInfo ownerInfo, Document document) {
        switch (cell.getColumnIndex()) {
            case 0: {
                ownerInfo.setTenantId(cell.getStringCellValue());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ownerInfo.setName(cell.getStringCellValue());
                break;
            }
            case 3: {
                cell.setCellType(CellType.STRING);
                ownerInfo.setMobileNumber(cell.getStringCellValue());
                break;
            }
            case 4: {
                ownerInfo.setFatherOrHusbandName(cell.getStringCellValue());
                break;
            }
            case 5: {
                ownerInfo.setRelationship(OwnerInfo.RelationshipEnum.fromValue((String)cell.getStringCellValue()));
                break;
            }
            case 6: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ownerInfo.setPermanentAddress(cell.getStringCellValue());
                break;
            }
            case 7: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ownerInfo.setOwnerType(cell.getStringCellValue());
                break;
            }
            case 8: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                document.setDocumentType(cell.getStringCellValue());
                break;
            }
            case 9: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                document.setDocumentUid(cell.getStringCellValue());
                break;
            }
            case 10: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ownerInfo.setEmailId(cell.getStringCellValue());
                break;
            }
            case 11: {
                if (StringUtils.isEmpty((Object)cell.getStringCellValue())) break;
                ownerInfo.setGender(cell.getStringCellValue());
                break;
            }
        }
        System.out.print("\t");
    }
}

