/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.controller;

import java.util.List;
import javax.validation.Valid;
import org.egov.dataupload.model.JobSearchRequest;
import org.egov.dataupload.model.ModuleDefRequest;
import org.egov.dataupload.model.ModuleDefResponse;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.model.UploaderResponse;
import org.egov.dataupload.service.DataUploadService;
import org.egov.dataupload.utils.DataUploadUtils;
import org.egov.dataupload.utils.ResponseInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class DataUploadController {
    @Autowired
    private DataUploadService dataUploadService;
    @Autowired
    public ResourceLoader resourceLoader;
    @Autowired
    public ResponseInfoFactory responseInfoFactory;
    @Autowired
    public DataUploadUtils dataUploadUtils;
    public static final Logger logger = LoggerFactory.getLogger(DataUploadController.class);

    @PostMapping(value={"jobs/_create"})
    @ResponseBody
    public ResponseEntity<?> upload(@RequestBody @Valid UploaderRequest uploaderRequest) throws Exception {
        logger.info("Inside controller");
        List uploadJobs = this.dataUploadService.createUploadJob(uploaderRequest);
        UploaderResponse result = UploaderResponse.builder().responseInfo(this.responseInfoFactory.createResponseInfoFromRequestInfo(uploaderRequest.getRequestInfo(), Boolean.valueOf(true))).uploadJobs(uploadJobs).build();
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"upload-definitions/_search"})
    @ResponseBody
    public ResponseEntity<?> definitionSearch(@RequestBody @Valid ModuleDefRequest moduleDefRequest) throws Exception {
        logger.info("Inside controller");
        List moduleDefs = this.dataUploadService.getModuleDefs();
        ModuleDefResponse result = ModuleDefResponse.builder().responseInfo(this.responseInfoFactory.createResponseInfoFromRequestInfo(moduleDefRequest.getRequestInfo(), Boolean.valueOf(true))).moduleDefs(moduleDefs).build();
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"jobs/_search"})
    @ResponseBody
    public ResponseEntity<?> jobsSearch(@RequestBody @Valid JobSearchRequest jobSearchRequest) throws Exception {
        logger.info("Inside controller");
        List uploadJobs = this.dataUploadService.getUploadJobs(jobSearchRequest);
        UploaderResponse result = UploaderResponse.builder().responseInfo(this.responseInfoFactory.createResponseInfoFromRequestInfo(jobSearchRequest.getRequestInfo(), Boolean.valueOf(true))).uploadJobs(uploadJobs).build();
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

