/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dataupload.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.egov.dataupload.model.UploadJob;
import org.egov.dataupload.model.UploaderRequest;
import org.egov.dataupload.service.DataUploadService;
import org.egov.dataupload.service.PropertyCustomUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

@Service
public class DataUploadConsumer {
    public static final Logger logger = LoggerFactory.getLogger(DataUploadConsumer.class);
    @Autowired
    private DataUploadService dataUploadService;
    @Autowired
    private PropertyCustomUploader propUploader;
    @Value(value="${property.module.name}")
    private String propertyModuleName;

    @KafkaListener(topics={"${kafka.topics.dataupload}"})
    public void listen(Map<String, Object> record, @Header(value="kafka_receivedTopic") String topic, @Header(value="kafka_receivedMessageKey") String key) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            logger.info("Consuming record : {}", record);
            UploaderRequest req = (UploaderRequest)mapper.convertValue(record, UploaderRequest.class);
            if (this.propertyModuleName.equalsIgnoreCase(((UploadJob)req.getUploadJobs().get(0)).getModuleName())) {
                this.propUploader.uploadPropertyData(req);
            } else {
                this.dataUploadService.excelDataUpload(req);
            }
        }
        catch (Exception e) {
            logger.error("Error while listening to value: " + record + " on topic: " + topic + ": ", (Throwable)e);
        }
    }
}

