/*
 * Decompiled with CFR 0.152.
 */
package org.egov;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.egov.dataupload.model.Definition;
import org.egov.dataupload.model.UploadDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DataUploadApplicationRunnerImpl
implements ApplicationRunner {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private Environment env;
    @Value(value="${upload.json.path}")
    private String jsonlist;
    private Map<String, UploadDefinition> uploadDefinitionMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(DataUploadApplicationRunnerImpl.class);

    public void run(ApplicationArguments arg0) throws Exception {
        try {
            logger.info("Reading json config files......");
            this.readFiles();
        }
        catch (Exception e) {
            logger.error("Exception while loading json config files: ", (Throwable)e);
        }
    }

    private void readFiles() {
        ConcurrentHashMap<String, UploadDefinition> map = new ConcurrentHashMap<String, UploadDefinition>();
        ObjectMapper mapper = new ObjectMapper();
        UploadDefinition uploadDefinition = null;
        try {
            List<String> ymlUrlS = Arrays.asList(this.jsonlist.split(","));
            if (0 == ymlUrlS.size()) {
                ymlUrlS.add(this.jsonlist);
            }
            for (String jsonLocation : ymlUrlS) {
                if (jsonLocation.startsWith("https://") || jsonLocation.startsWith("http://")) {
                    logger.info("Reading....: " + jsonLocation);
                    URL jsonFile = new URL(jsonLocation);
                    try {
                        uploadDefinition = (UploadDefinition)mapper.readValue((Reader)new InputStreamReader(jsonFile.openStream()), UploadDefinition.class);
                    }
                    catch (Exception e) {
                        logger.error("Exception while fetching upload definitions for: " + jsonLocation + " = ", (Throwable)e);
                        continue;
                    }
                    logger.info("Parsed to object: " + uploadDefinition.toString());
                    map.put(uploadDefinition.getModuleName(), uploadDefinition);
                    continue;
                }
                if (!jsonLocation.startsWith("file://")) continue;
                logger.info("Reading....: " + jsonLocation);
                Resource resource = this.resourceLoader.getResource(jsonLocation);
                File file = resource.getFile();
                try {
                    uploadDefinition = (UploadDefinition)mapper.readValue(file, UploadDefinition.class);
                }
                catch (Exception e) {
                    logger.error("Exception while fetching upload definitions for: " + jsonLocation + " = ", (Throwable)e);
                    continue;
                }
                logger.info("Parsed to object: " + uploadDefinition.toString());
                map.put(uploadDefinition.getModuleName(), uploadDefinition);
            }
        }
        catch (Exception e) {
            logger.error("Exception while loading json files: ", (Throwable)e);
        }
        this.uploadDefinitionMap = map;
    }

    public Optional<Definition> getUploadDefinition(String moduleName, String defName) {
        return ((UploadDefinition)this.getUploadDefinitionMap().get(moduleName)).getDefinitions().stream().filter(def -> def.getName().equals(defName)).findFirst();
    }

    public Map<String, UploadDefinition> getUploadDefinitionMap() {
        return Collections.unmodifiableMap(this.uploadDefinitionMap);
    }
}

