/*
 * Decompiled with CFR 0.152.
 */
package org.egov.win.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.contract.request.RequestInfo;
import org.egov.win.config.PropertyManager;
import org.egov.win.model.SearcherRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CronUtils {
    private static final Logger log = LoggerFactory.getLogger(CronUtils.class);
    @Autowired
    private PropertyManager propertyManager;
    private static final String MODULE_NAME = "{moduleName}";
    private static final String SEARCH_NAME = "{searchName}";

    public SearcherRequest preparePlainSearchReq(StringBuilder uri, String defName) {
        uri.append(this.propertyManager.getSearcherHost());
        String endPoint = this.propertyManager.getSearcherEndpoint().replace(MODULE_NAME, "impactemailer").replace(SEARCH_NAME, defName);
        uri.append(endPoint);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("intervalinsecs", this.propertyManager.getTimeInterval());
        SearcherRequest searcherRequest = SearcherRequest.builder().requestInfo(new RequestInfo()).searchCriteria(param).build();
        return searcherRequest;
    }

    public void prepareWSSearchReq(StringBuilder uri) {
        uri.append(this.propertyManager.getWsHost());
        String endPoint = this.propertyManager.getWsEndpoint().replace("{ulbCode}", this.propertyManager.getWsULBCode()).replace("{date}", String.valueOf(new Date().getTime())).replace("{interval}", this.propertyManager.getWsIntervalInMS().toString());
        uri.append(endPoint);
    }

    public ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    public Map<String, Object> getWeekWiseRevenue(List<Map<String, Object>> wsData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int index = 0;
        for (Map<String, Object> data : wsData) {
            map.put("Week" + index, data);
            ++index;
        }
        return map;
    }

    public String getDayAndMonth(Long epochTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(epochTime);
        StringBuilder date = new StringBuilder();
        String suffix = null;
        if (calendar.get(5) >= 11 && calendar.get(5) <= 13) {
            suffix = "th ";
        } else {
            Integer dateEndingwith = calendar.get(5) % 10;
            switch (dateEndingwith) {
                case 1: {
                    suffix = "st ";
                    break;
                }
                case 2: {
                    suffix = "nd ";
                    break;
                }
                case 3: {
                    suffix = "rd ";
                    break;
                }
                default: {
                    suffix = "th ";
                }
            }
        }
        date.append(calendar.get(5)).append(suffix).append(new DateFormatSymbols().getMonths()[calendar.get(2)]);
        return date.toString();
    }
}

