/*
 * Decompiled with CFR 0.152.
 */
package org.egov.win.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.egov.tracer.model.CustomException;
import org.egov.win.model.SearcherRequest;
import org.egov.win.repository.CronRepository;
import org.egov.win.utils.CronUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalAPIService {
    private static final Logger log = LoggerFactory.getLogger(ExternalAPIService.class);
    @Autowired
    private CronRepository repository;
    @Autowired
    private CronUtils utils;

    public List<Map<String, Object>> getRainmakerData(String defName) {
        StringBuilder uri = new StringBuilder();
        ObjectMapper mapper = this.utils.getObjectMapper();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        SearcherRequest request = this.utils.preparePlainSearchReq(uri, defName);
        Optional response = this.repository.fetchResult(uri, (Object)request);
        try {
            if (response.isPresent()) {
                Object parsedResponse = mapper.convertValue(response.get(), Map.class);
                List dataParsedToList = (List)mapper.convertValue(JsonPath.read((Object)parsedResponse, (String)"$.data", (Predicate[])new Predicate[0]), List.class);
                for (Object record : dataParsedToList) {
                    data.add((Map<String, Object>)mapper.convertValue(record, Map.class));
                }
            }
        }
        catch (Exception e) {
            throw new CustomException("EMAILER_DATA_RETREIVAL_FAILED", "Failed to retrieve data from the db");
        }
        return data;
    }

    public List<Map<String, Object>> getWSData() {
        StringBuilder uri = new StringBuilder();
        ObjectMapper mapper = this.utils.getObjectMapper();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        this.utils.prepareWSSearchReq(uri);
        String request = "{}";
        Optional response = this.repository.fetchResult(uri, (Object)request);
        try {
            if (response.isPresent()) {
                List dataParsedToList = (List)mapper.convertValue(response.get(), List.class);
                for (Object record : dataParsedToList) {
                    data.add((Map<String, Object>)mapper.convertValue(record, Map.class));
                }
            }
        }
        catch (Exception e) {
            throw new CustomException("EMAILER_DATA_RETREIVAL_FAILED", "Failed to retrieve data from WS module");
        }
        return data;
    }
}

