/*
 * Decompiled with CFR 0.152.
 */
package org.egov.win.service;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.egov.win.model.Body;
import org.egov.win.model.Email;
import org.egov.win.model.PGR;
import org.egov.win.model.PT;
import org.egov.win.model.StateWide;
import org.egov.win.model.TL;
import org.egov.win.model.WaterAndSewerage;
import org.egov.win.service.CronService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    @Autowired
    private CronService service;

    public String formatEmail(Email email) {
        Template t = this.service.getVelocityTemplate();
        VelocityContext context = new VelocityContext();
        this.buildEmailBody(email.getBody(), context);
        StringWriter writer = new StringWriter(10000);
        t.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private void buildEmailBody(Body body, VelocityContext context) {
        this.enrichHeaderData(body.getHeader(), context);
        if (null != body.getStateWide()) {
            this.enrichStateWideData(body.getStateWide(), context);
        }
        if (null != body.getPgr()) {
            this.enrichPGRData(body.getPgr(), context);
        }
        if (null != body.getPt()) {
            this.enrichPTData(body.getPt(), context);
        }
        if (null != body.getTl()) {
            this.enrichTLData(body.getTl(), context);
        }
        if (null != body.getWaterAndSewerage()) {
            this.enrichWSData(body.getWaterAndSewerage(), context);
        }
    }

    private void enrichHeaderData(List<Map<String, Object>> header, VelocityContext context) {
        this.fillData(header, context);
    }

    private void enrichStateWideData(StateWide stateWide, VelocityContext context) {
        this.fillData(stateWide.getNoOfCitizensResgistered(), context);
        this.fillData(stateWide.getRevenueCollected(), context);
        this.fillData(stateWide.getServicesApplied(), context);
        this.fillData(stateWide.getUlbCovered(), context);
    }

    private void enrichPGRData(PGR pgr, VelocityContext context) {
        this.fillData(pgr.getRedressal(), context);
        this.fillData(pgr.getTotalComplaints(), context);
        this.fillData(pgr.getUlbCovered(), context);
        this.fillData(pgr.getChannelBreakup().getIvr(), context);
        this.fillData(pgr.getChannelBreakup().getMobileApp(), context);
        this.fillData(pgr.getChannelBreakup().getWebApp(), context);
    }

    private void enrichPTData(PT pt, VelocityContext context) {
        this.fillData(pt.getNoOfProperties(), context);
        this.fillData(pt.getRevenueCollected(), context);
        this.fillData(pt.getUlbCovered(), context);
    }

    private void enrichTLData(TL tl, VelocityContext context) {
        this.fillData(tl.getLicenseIssued(), context);
        this.fillData(tl.getUlbCovered(), context);
    }

    private void enrichWSData(WaterAndSewerage ws, VelocityContext context) {
        this.fillData(ws.getServiceApplied(), context);
        this.fillData(ws.getRevenueCollected(), context);
        this.fillData(ws.getUlbCovered(), context);
    }

    private void fillData(List<Map<String, Object>> dataFromQuery, VelocityContext context) {
        dataFromQuery.forEach(record -> {
            for (String key : record.keySet()) {
                context.put(key, record.get(key));
            }
        });
    }
}

