/*
 * Decompiled with CFR 0.152.
 */
package org.egov.win.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.egov.win.model.Body;
import org.egov.win.model.Email;
import org.egov.win.model.EmailRequest;
import org.egov.win.model.PGR;
import org.egov.win.model.PGRChannelBreakup;
import org.egov.win.model.PT;
import org.egov.win.model.StateWide;
import org.egov.win.model.TL;
import org.egov.win.model.WaterAndSewerage;
import org.egov.win.producer.Producer;
import org.egov.win.service.EmailService;
import org.egov.win.service.ExternalAPIService;
import org.egov.win.utils.CronUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CronService {
    private static final Logger log = LoggerFactory.getLogger(CronService.class);
    @Autowired
    private EmailService emailService;
    @Autowired
    private CronUtils utils;
    @Autowired
    private ExternalAPIService externalAPIService;
    @Autowired
    private Producer producer;
    @Value(value="${egov.core.notification.email.topic}")
    private String emailTopic;
    @Value(value="${egov.impact.emailer.interval.in.secs}")
    private Long timeInterval;
    @Value(value="${egov.impact.emailer.email.to.address}")
    private String toAddress;
    @Value(value="${egov.impact.emailer.email.subject}")
    private String subject;

    public void fetchData() {
        try {
            Email email = this.getDataFromDb();
            String content = this.emailService.formatEmail(email);
            this.send(email, content);
        }
        catch (Exception e) {
            log.info("Email will not be sent, ERROR: ", (Throwable)e);
        }
    }

    private Email getDataFromDb() {
        Body body = new Body();
        this.enrichHeadersOfTheTable(body);
        List wsData = this.enrichBodyWithStateWideData(body);
        this.enrichBodyWithPGRData(body);
        this.enrichBodyWithPTData(body);
        this.enrichBodyWithTLData(body);
        this.enrichBodyWithWSData(body, wsData);
        return Email.builder().body(body).build();
    }

    private void enrichHeadersOfTheTable(Body body) {
        String prefix = "Week";
        Integer noOfWeeks = 6;
        ArrayList header = new ArrayList();
        for (int week = 0; week < noOfWeeks; ++week) {
            HashMap<String, String> date = new HashMap<String, String>();
            date.put(prefix + week, this.utils.getDayAndMonth(Long.valueOf(System.currentTimeMillis() - this.timeInterval * 1000L * (long)week)));
            header.add(date);
        }
        body.setHeader(header);
    }

    private List<Map<String, Object>> enrichBodyWithStateWideData(Body body) {
        List data = this.externalAPIService.getRainmakerData("stateWideData");
        List wsData = this.externalAPIService.getWSData();
        ArrayList ulbCovered = new ArrayList();
        ArrayList revenueCollected = new ArrayList();
        ArrayList servicesApplied = new ArrayList();
        ArrayList noOfCitizensResgistered = new ArrayList();
        Map map = this.utils.getWeekWiseRevenue(wsData);
        for (Map record : data) {
            HashMap ulbCoveredPerWeek = new HashMap();
            HashMap<String, BigDecimal> revenueCollectedPerWeek = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> servicesAppliedPerWeek = new HashMap<String, BigDecimal>();
            HashMap noOfCitizensResgisteredPerWeek = new HashMap();
            String prefix = "Week";
            Integer noOfWeeks = 6;
            Integer wsIndex = 0;
            for (int week = 0; week < noOfWeeks; ++week) {
                if (!record.get("day").equals(prefix + week)) continue;
                ulbCoveredPerWeek.put("w" + week + "ulbc", record.get("ulbcovered"));
                revenueCollectedPerWeek.put("w" + week + "revcoll", new BigDecimal(record.get("revenuecollected").toString()).add(new BigDecimal(((Map)map.get(prefix + week)).get("revenueCollected").toString())));
                servicesAppliedPerWeek.put("w" + week + "serapp", new BigDecimal(record.get("servicesapplied").toString()).add(new BigDecimal(((Map)map.get(prefix + week)).get("servicesApplied").toString())));
                noOfCitizensResgisteredPerWeek.put("w" + week + "citreg", record.get("noofusersregistered"));
                Integer n = wsIndex;
                Integer n2 = wsIndex = Integer.valueOf(wsIndex + 1);
            }
            ulbCovered.add(ulbCoveredPerWeek);
            revenueCollected.add(revenueCollectedPerWeek);
            servicesApplied.add(servicesAppliedPerWeek);
            noOfCitizensResgistered.add(noOfCitizensResgisteredPerWeek);
        }
        StateWide stateWide = StateWide.builder().noOfCitizensResgistered(noOfCitizensResgistered).revenueCollected(revenueCollected).servicesApplied(servicesApplied).ulbCovered(ulbCovered).build();
        body.setStateWide(stateWide);
        return wsData;
    }

    private void enrichBodyWithPGRData(Body body) {
        List data = this.externalAPIService.getRainmakerData("pgrData");
        ArrayList ulbCovered = new ArrayList();
        ArrayList totalComplaints = new ArrayList();
        ArrayList redressal = new ArrayList();
        for (Map record : data) {
            HashMap ulbCoveredPerWeek = new HashMap();
            HashMap totalComplaintsPerWeek = new HashMap();
            HashMap redressalPerWeek = new HashMap();
            String prefix = "Week";
            Integer noOfWeeks = 6;
            for (int week = 0; week < noOfWeeks; ++week) {
                if (!record.get("day").equals(prefix + week)) continue;
                ulbCoveredPerWeek.put("w" + week + "pgrulbc", record.get("ulbcovered"));
                totalComplaintsPerWeek.put("w" + week + "pgrtcmp", record.get("totalcomplaints"));
                redressalPerWeek.put("w" + week + "pgrredd", record.get("redressal"));
            }
            ulbCovered.add(ulbCoveredPerWeek);
            totalComplaints.add(totalComplaintsPerWeek);
            redressal.add(redressalPerWeek);
        }
        PGR pgr = PGR.builder().redressal(redressal).totalComplaints(totalComplaints).ulbCovered(ulbCovered).build();
        this.enrichBodyWithPGRChannelData(body, pgr);
        body.setPgr(pgr);
    }

    private void enrichBodyWithPGRChannelData(Body body, PGR pgr) {
        List data = this.externalAPIService.getRainmakerData("pgrChannelData");
        ArrayList ivr = new ArrayList();
        ArrayList mobiileApp = new ArrayList();
        ArrayList webApp = new ArrayList();
        for (Map record : data) {
            HashMap ivrPerWeek = new HashMap();
            HashMap mobileAppPerWeek = new HashMap();
            HashMap webAppPerWeek = new HashMap();
            String prefix = "Week";
            Integer noOfWeeks = 6;
            for (int week = 0; week < noOfWeeks; ++week) {
                if (!record.get("day").equals(prefix + week)) continue;
                ivrPerWeek.put("w" + week + "pgrchnlivr", record.get("ivr"));
                mobileAppPerWeek.put("w" + week + "pgrchnlmapp", record.get("mobileapp"));
                webAppPerWeek.put("w" + week + "pgrchnlweb", record.get("webapp"));
            }
            ivr.add(ivrPerWeek);
            mobiileApp.add(mobileAppPerWeek);
            webApp.add(webAppPerWeek);
        }
        PGRChannelBreakup channel = PGRChannelBreakup.builder().ivr(ivr).mobileApp(mobiileApp).webApp(webApp).build();
        pgr.setChannelBreakup(channel);
    }

    private void enrichBodyWithPTData(Body body) {
        List data = this.externalAPIService.getRainmakerData("ptData");
        ArrayList ulbCovered = new ArrayList();
        ArrayList revenueCollected = new ArrayList();
        ArrayList noOfProperties = new ArrayList();
        for (Map record : data) {
            HashMap ulbCoveredPerWeek = new HashMap();
            HashMap revenueCollectedPerWeek = new HashMap();
            HashMap noOfPropertiesPerWeek = new HashMap();
            String prefix = "Week";
            Integer noOfWeeks = 6;
            for (int week = 0; week < noOfWeeks; ++week) {
                if (!record.get("day").equals(prefix + week)) continue;
                ulbCoveredPerWeek.put("w" + week + "ptulbc", record.get("ulbcovered"));
                revenueCollectedPerWeek.put("w" + week + "ptrevcoll", record.get("revenuecollected"));
                noOfPropertiesPerWeek.put("w" + week + "ptnoofprp", record.get("noofpropertiescreated"));
            }
            ulbCovered.add(ulbCoveredPerWeek);
            revenueCollected.add(revenueCollectedPerWeek);
            noOfProperties.add(noOfPropertiesPerWeek);
        }
        PT pt = PT.builder().noOfProperties(noOfProperties).ulbCovered(ulbCovered).revenueCollected(revenueCollected).build();
        body.setPt(pt);
    }

    private void enrichBodyWithTLData(Body body) {
        List data = this.externalAPIService.getRainmakerData("tlData");
        ArrayList ulbCovered = new ArrayList();
        ArrayList licenseIssued = new ArrayList();
        for (Map record : data) {
            HashMap ulbCoveredPerWeek = new HashMap();
            HashMap licenseIssuedPerWeek = new HashMap();
            String prefix = "Week";
            Integer noOfWeeks = 6;
            for (int week = 0; week < noOfWeeks; ++week) {
                if (!record.get("day").equals(prefix + week)) continue;
                ulbCoveredPerWeek.put("w" + week + "tlulbc", record.get("ulbcovered"));
                licenseIssuedPerWeek.put("w" + week + "tllicissued", record.get("licenseissued"));
            }
            ulbCovered.add(ulbCoveredPerWeek);
            licenseIssued.add(licenseIssuedPerWeek);
        }
        TL tl = TL.builder().ulbCovered(ulbCovered).licenseIssued(licenseIssued).build();
        body.setTl(tl);
    }

    private void enrichBodyWithWSData(Body body, List<Map<String, Object>> data) {
        ArrayList ulbCovered = new ArrayList();
        ArrayList revenueCollected = new ArrayList();
        ArrayList servicesApplied = new ArrayList();
        Integer week = 0;
        for (Map<String, Object> record : data) {
            HashMap<String, Object> ulbCoveredPerWeek = new HashMap<String, Object>();
            HashMap<String, Object> revenueCollectedPerWeek = new HashMap<String, Object>();
            HashMap<String, Object> servicesAppliedPerWeek = new HashMap<String, Object>();
            ulbCoveredPerWeek.put("w" + week + "wsulbc", record.get("ulbsCovered"));
            revenueCollectedPerWeek.put("w" + week + "wsrevcoll", record.get("revenueCollected"));
            servicesAppliedPerWeek.put("w" + week + "wsserapp", record.get("servicesApplied"));
            ulbCovered.add(ulbCoveredPerWeek);
            revenueCollected.add(revenueCollectedPerWeek);
            servicesApplied.add(servicesAppliedPerWeek);
            Integer n = week;
            Integer n2 = week = Integer.valueOf(week + 1);
        }
        WaterAndSewerage waterAndSewerage = WaterAndSewerage.builder().revenueCollected(revenueCollected).serviceApplied(servicesApplied).ulbCovered(ulbCovered).build();
        body.setWaterAndSewerage(waterAndSewerage);
    }

    private void send(Email email, String content) {
        String[] addresses = this.toAddress.split(",");
        for (String address : Arrays.asList(addresses)) {
            email.setTo(address);
            email.setSubject(this.subject);
            EmailRequest request = EmailRequest.builder().email(email.getTo()).subject(email.getSubject()).isHTML(true).body(content).build();
            log.info("EMAIL: " + request);
            this.producer.push(this.emailTopic, (Object)request);
        }
    }

    public Template getVelocityTemplate() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        Template t = ve.getTemplate("velocity/weeklyimpactflasher.vm");
        return t;
    }
}

