/*
 * Decompiled with CFR 0.152.
 */
package org.egov.win.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Optional;
import org.egov.tracer.model.ServiceCallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Repository
public class CronRepository {
    private static final Logger log = LoggerFactory.getLogger(CronRepository.class);
    @Autowired
    private RestTemplate restTemplate;

    public Optional<Object> fetchResult(StringBuilder uri, Object request) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Object response = null;
        try {
            response = this.restTemplate.postForObject(uri.toString(), request, JsonNode.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            log.error("External Service threw an Exception: ", (Throwable)e);
            throw new ServiceCallException(e.getResponseBodyAsString());
        }
        catch (Exception e) {
            log.error("Exception while fetching from external service: ", (Throwable)e);
        }
        return Optional.ofNullable(response);
    }
}

