/*
 * Decompiled with CFR 0.152.
 */
package digit.models.coremodels;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import digit.models.coremodels.AuditDetails;
import digit.models.coremodels.BillDetail;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.util.CollectionUtils;

public class Bill {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="mobileNumber")
    private String mobileNumber;
    @JsonProperty(value="paidBy")
    private String paidBy;
    @JsonProperty(value="payerName")
    private String payerName;
    @JsonProperty(value="payerAddress")
    private String payerAddress;
    @JsonProperty(value="payerEmail")
    private String payerEmail;
    @JsonProperty(value="payerId")
    private String payerId;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="reasonForCancellation")
    private String reasonForCancellation;
    @JsonProperty(value="isCancelled")
    private Boolean isCancelled;
    @JsonProperty(value="additionalDetails")
    private JsonNode additionalDetails;
    @JsonProperty(value="billDetails")
    @Valid
    private List<BillDetail> billDetails;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;
    @JsonProperty(value="collectionModesNotAllowed")
    private List<String> collectionModesNotAllowed;
    @JsonProperty(value="partPaymentAllowed")
    private Boolean partPaymentAllowed;
    @JsonProperty(value="isAdvanceAllowed")
    private Boolean isAdvanceAllowed;
    @JsonProperty(value="minimumAmountToBePaid")
    private BigDecimal minimumAmountToBePaid;
    @JsonProperty(value="businessService")
    private String businessService;
    @JsonProperty(value="totalAmount")
    private BigDecimal totalAmount;
    @JsonProperty(value="consumerCode")
    private String consumerCode;
    @JsonProperty(value="billNumber")
    private String billNumber;
    @JsonProperty(value="billDate")
    private Long billDate;
    @JsonProperty(value="amountPaid")
    private BigDecimal amountPaid;

    public Boolean addBillDetail(BillDetail billDetail) {
        if (CollectionUtils.isEmpty(this.billDetails)) {
            this.billDetails = new ArrayList<BillDetail>();
            return this.billDetails.add(billDetail);
        }
        if (!this.billDetails.contains(billDetail)) {
            return this.billDetails.add(billDetail);
        }
        return false;
    }

    public static BillBuilder builder() {
        return new BillBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getPaidBy() {
        return this.paidBy;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public String getPayerAddress() {
        return this.payerAddress;
    }

    public String getPayerEmail() {
        return this.payerEmail;
    }

    public String getPayerId() {
        return this.payerId;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public String getReasonForCancellation() {
        return this.reasonForCancellation;
    }

    public Boolean getIsCancelled() {
        return this.isCancelled;
    }

    public JsonNode getAdditionalDetails() {
        return this.additionalDetails;
    }

    public List<BillDetail> getBillDetails() {
        return this.billDetails;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public List<String> getCollectionModesNotAllowed() {
        return this.collectionModesNotAllowed;
    }

    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    public Boolean getIsAdvanceAllowed() {
        return this.isAdvanceAllowed;
    }

    public BigDecimal getMinimumAmountToBePaid() {
        return this.minimumAmountToBePaid;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public Long getBillDate() {
        return this.billDate;
    }

    public BigDecimal getAmountPaid() {
        return this.amountPaid;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="mobileNumber")
    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @JsonProperty(value="paidBy")
    public void setPaidBy(String paidBy) {
        this.paidBy = paidBy;
    }

    @JsonProperty(value="payerName")
    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    @JsonProperty(value="payerAddress")
    public void setPayerAddress(String payerAddress) {
        this.payerAddress = payerAddress;
    }

    @JsonProperty(value="payerEmail")
    public void setPayerEmail(String payerEmail) {
        this.payerEmail = payerEmail;
    }

    @JsonProperty(value="payerId")
    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    @JsonProperty(value="status")
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @JsonProperty(value="reasonForCancellation")
    public void setReasonForCancellation(String reasonForCancellation) {
        this.reasonForCancellation = reasonForCancellation;
    }

    @JsonProperty(value="isCancelled")
    public void setIsCancelled(Boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(JsonNode additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="billDetails")
    public void setBillDetails(List<BillDetail> billDetails) {
        this.billDetails = billDetails;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="collectionModesNotAllowed")
    public void setCollectionModesNotAllowed(List<String> collectionModesNotAllowed) {
        this.collectionModesNotAllowed = collectionModesNotAllowed;
    }

    @JsonProperty(value="partPaymentAllowed")
    public void setPartPaymentAllowed(Boolean partPaymentAllowed) {
        this.partPaymentAllowed = partPaymentAllowed;
    }

    @JsonProperty(value="isAdvanceAllowed")
    public void setIsAdvanceAllowed(Boolean isAdvanceAllowed) {
        this.isAdvanceAllowed = isAdvanceAllowed;
    }

    @JsonProperty(value="minimumAmountToBePaid")
    public void setMinimumAmountToBePaid(BigDecimal minimumAmountToBePaid) {
        this.minimumAmountToBePaid = minimumAmountToBePaid;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="consumerCode")
    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    @JsonProperty(value="billNumber")
    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    @JsonProperty(value="billDate")
    public void setBillDate(Long billDate) {
        this.billDate = billDate;
    }

    @JsonProperty(value="amountPaid")
    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public String toString() {
        return "Bill(id=" + this.getId() + ", mobileNumber=" + this.getMobileNumber() + ", paidBy=" + this.getPaidBy() + ", payerName=" + this.getPayerName() + ", payerAddress=" + this.getPayerAddress() + ", payerEmail=" + this.getPayerEmail() + ", payerId=" + this.getPayerId() + ", status=" + (Object)((Object)this.getStatus()) + ", reasonForCancellation=" + this.getReasonForCancellation() + ", isCancelled=" + this.getIsCancelled() + ", additionalDetails=" + this.getAdditionalDetails() + ", billDetails=" + this.getBillDetails() + ", tenantId=" + this.getTenantId() + ", auditDetails=" + this.getAuditDetails() + ", collectionModesNotAllowed=" + this.getCollectionModesNotAllowed() + ", partPaymentAllowed=" + this.getPartPaymentAllowed() + ", isAdvanceAllowed=" + this.getIsAdvanceAllowed() + ", minimumAmountToBePaid=" + this.getMinimumAmountToBePaid() + ", businessService=" + this.getBusinessService() + ", totalAmount=" + this.getTotalAmount() + ", consumerCode=" + this.getConsumerCode() + ", billNumber=" + this.getBillNumber() + ", billDate=" + this.getBillDate() + ", amountPaid=" + this.getAmountPaid() + ")";
    }

    public Bill() {
    }

    public Bill(String id, String mobileNumber, String paidBy, String payerName, String payerAddress, String payerEmail, String payerId, StatusEnum status, String reasonForCancellation, Boolean isCancelled, JsonNode additionalDetails, List<BillDetail> billDetails, String tenantId, AuditDetails auditDetails, List<String> collectionModesNotAllowed, Boolean partPaymentAllowed, Boolean isAdvanceAllowed, BigDecimal minimumAmountToBePaid, String businessService, BigDecimal totalAmount, String consumerCode, String billNumber, Long billDate, BigDecimal amountPaid) {
        this.id = id;
        this.mobileNumber = mobileNumber;
        this.paidBy = paidBy;
        this.payerName = payerName;
        this.payerAddress = payerAddress;
        this.payerEmail = payerEmail;
        this.payerId = payerId;
        this.status = status;
        this.reasonForCancellation = reasonForCancellation;
        this.isCancelled = isCancelled;
        this.additionalDetails = additionalDetails;
        this.billDetails = billDetails;
        this.tenantId = tenantId;
        this.auditDetails = auditDetails;
        this.collectionModesNotAllowed = collectionModesNotAllowed;
        this.partPaymentAllowed = partPaymentAllowed;
        this.isAdvanceAllowed = isAdvanceAllowed;
        this.minimumAmountToBePaid = minimumAmountToBePaid;
        this.businessService = businessService;
        this.totalAmount = totalAmount;
        this.consumerCode = consumerCode;
        this.billNumber = billNumber;
        this.billDate = billDate;
        this.amountPaid = amountPaid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bill)) {
            return false;
        }
        Bill other = (Bill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isCancelled = this.getIsCancelled();
        Boolean other$isCancelled = other.getIsCancelled();
        if (this$isCancelled == null ? other$isCancelled != null : !((Object)this$isCancelled).equals(other$isCancelled)) {
            return false;
        }
        Boolean this$partPaymentAllowed = this.getPartPaymentAllowed();
        Boolean other$partPaymentAllowed = other.getPartPaymentAllowed();
        if (this$partPaymentAllowed == null ? other$partPaymentAllowed != null : !((Object)this$partPaymentAllowed).equals(other$partPaymentAllowed)) {
            return false;
        }
        Boolean this$isAdvanceAllowed = this.getIsAdvanceAllowed();
        Boolean other$isAdvanceAllowed = other.getIsAdvanceAllowed();
        if (this$isAdvanceAllowed == null ? other$isAdvanceAllowed != null : !((Object)this$isAdvanceAllowed).equals(other$isAdvanceAllowed)) {
            return false;
        }
        Long this$billDate = this.getBillDate();
        Long other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !((Object)this$billDate).equals(other$billDate)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$mobileNumber = this.getMobileNumber();
        String other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !this$mobileNumber.equals(other$mobileNumber)) {
            return false;
        }
        String this$paidBy = this.getPaidBy();
        String other$paidBy = other.getPaidBy();
        if (this$paidBy == null ? other$paidBy != null : !this$paidBy.equals(other$paidBy)) {
            return false;
        }
        String this$payerName = this.getPayerName();
        String other$payerName = other.getPayerName();
        if (this$payerName == null ? other$payerName != null : !this$payerName.equals(other$payerName)) {
            return false;
        }
        String this$payerAddress = this.getPayerAddress();
        String other$payerAddress = other.getPayerAddress();
        if (this$payerAddress == null ? other$payerAddress != null : !this$payerAddress.equals(other$payerAddress)) {
            return false;
        }
        String this$payerEmail = this.getPayerEmail();
        String other$payerEmail = other.getPayerEmail();
        if (this$payerEmail == null ? other$payerEmail != null : !this$payerEmail.equals(other$payerEmail)) {
            return false;
        }
        String this$payerId = this.getPayerId();
        String other$payerId = other.getPayerId();
        if (this$payerId == null ? other$payerId != null : !this$payerId.equals(other$payerId)) {
            return false;
        }
        StatusEnum this$status = this.getStatus();
        StatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$reasonForCancellation = this.getReasonForCancellation();
        String other$reasonForCancellation = other.getReasonForCancellation();
        if (this$reasonForCancellation == null ? other$reasonForCancellation != null : !this$reasonForCancellation.equals(other$reasonForCancellation)) {
            return false;
        }
        JsonNode this$additionalDetails = this.getAdditionalDetails();
        JsonNode other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        List<BillDetail> this$billDetails = this.getBillDetails();
        List<BillDetail> other$billDetails = other.getBillDetails();
        if (this$billDetails == null ? other$billDetails != null : !((Object)this$billDetails).equals(other$billDetails)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        List<String> this$collectionModesNotAllowed = this.getCollectionModesNotAllowed();
        List<String> other$collectionModesNotAllowed = other.getCollectionModesNotAllowed();
        if (this$collectionModesNotAllowed == null ? other$collectionModesNotAllowed != null : !((Object)this$collectionModesNotAllowed).equals(other$collectionModesNotAllowed)) {
            return false;
        }
        BigDecimal this$minimumAmountToBePaid = this.getMinimumAmountToBePaid();
        BigDecimal other$minimumAmountToBePaid = other.getMinimumAmountToBePaid();
        if (this$minimumAmountToBePaid == null ? other$minimumAmountToBePaid != null : !((Object)this$minimumAmountToBePaid).equals(other$minimumAmountToBePaid)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        if (this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        String this$consumerCode = this.getConsumerCode();
        String other$consumerCode = other.getConsumerCode();
        if (this$consumerCode == null ? other$consumerCode != null : !this$consumerCode.equals(other$consumerCode)) {
            return false;
        }
        String this$billNumber = this.getBillNumber();
        String other$billNumber = other.getBillNumber();
        if (this$billNumber == null ? other$billNumber != null : !this$billNumber.equals(other$billNumber)) {
            return false;
        }
        BigDecimal this$amountPaid = this.getAmountPaid();
        BigDecimal other$amountPaid = other.getAmountPaid();
        return !(this$amountPaid == null ? other$amountPaid != null : !((Object)this$amountPaid).equals(other$amountPaid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isCancelled = this.getIsCancelled();
        result = result * 59 + ($isCancelled == null ? 43 : ((Object)$isCancelled).hashCode());
        Boolean $partPaymentAllowed = this.getPartPaymentAllowed();
        result = result * 59 + ($partPaymentAllowed == null ? 43 : ((Object)$partPaymentAllowed).hashCode());
        Boolean $isAdvanceAllowed = this.getIsAdvanceAllowed();
        result = result * 59 + ($isAdvanceAllowed == null ? 43 : ((Object)$isAdvanceAllowed).hashCode());
        Long $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : ((Object)$billDate).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : $mobileNumber.hashCode());
        String $paidBy = this.getPaidBy();
        result = result * 59 + ($paidBy == null ? 43 : $paidBy.hashCode());
        String $payerName = this.getPayerName();
        result = result * 59 + ($payerName == null ? 43 : $payerName.hashCode());
        String $payerAddress = this.getPayerAddress();
        result = result * 59 + ($payerAddress == null ? 43 : $payerAddress.hashCode());
        String $payerEmail = this.getPayerEmail();
        result = result * 59 + ($payerEmail == null ? 43 : $payerEmail.hashCode());
        String $payerId = this.getPayerId();
        result = result * 59 + ($payerId == null ? 43 : $payerId.hashCode());
        StatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $reasonForCancellation = this.getReasonForCancellation();
        result = result * 59 + ($reasonForCancellation == null ? 43 : $reasonForCancellation.hashCode());
        JsonNode $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        List<BillDetail> $billDetails = this.getBillDetails();
        result = result * 59 + ($billDetails == null ? 43 : ((Object)$billDetails).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        List<String> $collectionModesNotAllowed = this.getCollectionModesNotAllowed();
        result = result * 59 + ($collectionModesNotAllowed == null ? 43 : ((Object)$collectionModesNotAllowed).hashCode());
        BigDecimal $minimumAmountToBePaid = this.getMinimumAmountToBePaid();
        result = result * 59 + ($minimumAmountToBePaid == null ? 43 : ((Object)$minimumAmountToBePaid).hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        String $consumerCode = this.getConsumerCode();
        result = result * 59 + ($consumerCode == null ? 43 : $consumerCode.hashCode());
        String $billNumber = this.getBillNumber();
        result = result * 59 + ($billNumber == null ? 43 : $billNumber.hashCode());
        BigDecimal $amountPaid = this.getAmountPaid();
        result = result * 59 + ($amountPaid == null ? 43 : ((Object)$amountPaid).hashCode());
        return result;
    }

    public static class BillBuilder {
        private String id;
        private String mobileNumber;
        private String paidBy;
        private String payerName;
        private String payerAddress;
        private String payerEmail;
        private String payerId;
        private StatusEnum status;
        private String reasonForCancellation;
        private Boolean isCancelled;
        private JsonNode additionalDetails;
        private List<BillDetail> billDetails;
        private String tenantId;
        private AuditDetails auditDetails;
        private List<String> collectionModesNotAllowed;
        private Boolean partPaymentAllowed;
        private Boolean isAdvanceAllowed;
        private BigDecimal minimumAmountToBePaid;
        private String businessService;
        private BigDecimal totalAmount;
        private String consumerCode;
        private String billNumber;
        private Long billDate;
        private BigDecimal amountPaid;

        BillBuilder() {
        }

        @JsonProperty(value="id")
        public BillBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="mobileNumber")
        public BillBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        @JsonProperty(value="paidBy")
        public BillBuilder paidBy(String paidBy) {
            this.paidBy = paidBy;
            return this;
        }

        @JsonProperty(value="payerName")
        public BillBuilder payerName(String payerName) {
            this.payerName = payerName;
            return this;
        }

        @JsonProperty(value="payerAddress")
        public BillBuilder payerAddress(String payerAddress) {
            this.payerAddress = payerAddress;
            return this;
        }

        @JsonProperty(value="payerEmail")
        public BillBuilder payerEmail(String payerEmail) {
            this.payerEmail = payerEmail;
            return this;
        }

        @JsonProperty(value="payerId")
        public BillBuilder payerId(String payerId) {
            this.payerId = payerId;
            return this;
        }

        @JsonProperty(value="status")
        public BillBuilder status(StatusEnum status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="reasonForCancellation")
        public BillBuilder reasonForCancellation(String reasonForCancellation) {
            this.reasonForCancellation = reasonForCancellation;
            return this;
        }

        @JsonProperty(value="isCancelled")
        public BillBuilder isCancelled(Boolean isCancelled) {
            this.isCancelled = isCancelled;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public BillBuilder additionalDetails(JsonNode additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="billDetails")
        public BillBuilder billDetails(List<BillDetail> billDetails) {
            this.billDetails = billDetails;
            return this;
        }

        @JsonProperty(value="tenantId")
        public BillBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BillBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="collectionModesNotAllowed")
        public BillBuilder collectionModesNotAllowed(List<String> collectionModesNotAllowed) {
            this.collectionModesNotAllowed = collectionModesNotAllowed;
            return this;
        }

        @JsonProperty(value="partPaymentAllowed")
        public BillBuilder partPaymentAllowed(Boolean partPaymentAllowed) {
            this.partPaymentAllowed = partPaymentAllowed;
            return this;
        }

        @JsonProperty(value="isAdvanceAllowed")
        public BillBuilder isAdvanceAllowed(Boolean isAdvanceAllowed) {
            this.isAdvanceAllowed = isAdvanceAllowed;
            return this;
        }

        @JsonProperty(value="minimumAmountToBePaid")
        public BillBuilder minimumAmountToBePaid(BigDecimal minimumAmountToBePaid) {
            this.minimumAmountToBePaid = minimumAmountToBePaid;
            return this;
        }

        @JsonProperty(value="businessService")
        public BillBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public BillBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @JsonProperty(value="consumerCode")
        public BillBuilder consumerCode(String consumerCode) {
            this.consumerCode = consumerCode;
            return this;
        }

        @JsonProperty(value="billNumber")
        public BillBuilder billNumber(String billNumber) {
            this.billNumber = billNumber;
            return this;
        }

        @JsonProperty(value="billDate")
        public BillBuilder billDate(Long billDate) {
            this.billDate = billDate;
            return this;
        }

        @JsonProperty(value="amountPaid")
        public BillBuilder amountPaid(BigDecimal amountPaid) {
            this.amountPaid = amountPaid;
            return this;
        }

        public Bill build() {
            return new Bill(this.id, this.mobileNumber, this.paidBy, this.payerName, this.payerAddress, this.payerEmail, this.payerId, this.status, this.reasonForCancellation, this.isCancelled, this.additionalDetails, this.billDetails, this.tenantId, this.auditDetails, this.collectionModesNotAllowed, this.partPaymentAllowed, this.isAdvanceAllowed, this.minimumAmountToBePaid, this.businessService, this.totalAmount, this.consumerCode, this.billNumber, this.billDate, this.amountPaid);
        }

        public String toString() {
            return "Bill.BillBuilder(id=" + this.id + ", mobileNumber=" + this.mobileNumber + ", paidBy=" + this.paidBy + ", payerName=" + this.payerName + ", payerAddress=" + this.payerAddress + ", payerEmail=" + this.payerEmail + ", payerId=" + this.payerId + ", status=" + (Object)((Object)this.status) + ", reasonForCancellation=" + this.reasonForCancellation + ", isCancelled=" + this.isCancelled + ", additionalDetails=" + this.additionalDetails + ", billDetails=" + this.billDetails + ", tenantId=" + this.tenantId + ", auditDetails=" + this.auditDetails + ", collectionModesNotAllowed=" + this.collectionModesNotAllowed + ", partPaymentAllowed=" + this.partPaymentAllowed + ", isAdvanceAllowed=" + this.isAdvanceAllowed + ", minimumAmountToBePaid=" + this.minimumAmountToBePaid + ", businessService=" + this.businessService + ", totalAmount=" + this.totalAmount + ", consumerCode=" + this.consumerCode + ", billNumber=" + this.billNumber + ", billDate=" + this.billDate + ", amountPaid=" + this.amountPaid + ")";
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        CANCELLED("CANCELLED"),
        PAID("PAID"),
        EXPIRED("EXPIRED");

        private final String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static boolean contains(String test) {
            for (StatusEnum val : StatusEnum.values()) {
                if (!val.name().equalsIgnoreCase(test)) continue;
                return true;
            }
            return false;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

