package digit.models.coremodels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@EqualsAndHashCode
public class Payment {

    @Size(max = 64)
    @JsonProperty("id")
    private String id;

    @NotNull
    @Size(max = 64)
    @JsonProperty("tenantId")
    private String tenantId;

    @JsonProperty("totalDue")
    private BigDecimal totalDue;

    @NotNull
    @JsonProperty("totalAmountPaid")
    private BigDecimal totalAmountPaid;

    @Size(max = 128)
    @JsonProperty("transactionNumber")
    private String transactionNumber;

    @JsonProperty("transactionDate")
    private Long transactionDate;

    @NotNull
    @JsonProperty("paymentMode")
    private String paymentMode;

    @JsonProperty("instrumentDate")
    private Long instrumentDate;

    @Size(max = 128)
    @JsonProperty("instrumentNumber")
    private String instrumentNumber;

    @JsonProperty("instrumentStatus")
    private String instrumentStatus;

    @Size(max = 64)
    @JsonProperty("ifscCode")
    private String ifscCode;

    @JsonProperty("auditDetails")
    private AuditDetails auditDetails;

    @JsonProperty("additionalDetails")
    private JsonNode additionalDetails;

    @JsonProperty("paymentDetails")
    @Valid
    private List<PaymentDetail> paymentDetails;

    @Size(max = 128)
    @NotNull
    @JsonProperty("paidBy")
    private String paidBy;

    @Size(max = 64)
    @NotNull
    @JsonProperty("mobileNumber")
    private String mobileNumber;

    @Size(max = 128)
    @JsonProperty("payerName")
    private String payerName;

    @Size(max = 1024)
    @JsonProperty("payerAddress")
    private String payerAddress;

    @Size(max = 64)
    @JsonProperty("payerEmail")
    private String payerEmail;

    @Size(max = 64)
    @JsonProperty("payerId")
    private String payerId;

    @JsonProperty("paymentStatus")
    private String paymentStatus;

    public Payment addpaymentDetailsItem(PaymentDetail paymentDetail) {
        if (this.paymentDetails == null) {
            this.paymentDetails = new ArrayList<>();
        }
        this.paymentDetails.add(paymentDetail);
        return this;
    }

}
