/*
 * Decompiled with CFR 0.152.
 */
package com.digit.services.individual;

import com.digit.config.ApiProperties;
import com.digit.exception.DigitClientException;
import com.digit.services.individual.model.Individual;
import com.digit.services.individual.model.IndividualRequest;
import com.digit.services.individual.model.IndividualResponse;
import com.digit.services.individual.model.IndividualSearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class IndividualClient {
    private static final Logger log = LoggerFactory.getLogger(IndividualClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;
    private static final int DEFAULT_LIMIT = 10;
    private static final int DEFAULT_OFFSET = 0;

    public IndividualClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        log.debug("IndividualClient created with RestTemplate: {}", (Object)restTemplate.getClass().getSimpleName());
    }

    public Individual createIndividual(Individual individual) {
        if (individual == null) {
            throw new DigitClientException("Individual cannot be null");
        }
        try {
            log.debug("Creating individual: {}", (Object)individual.getGivenName());
            String url = this.apiProperties.getIndividualServiceUrl() + "/individual/v1";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            IndividualRequest request = IndividualRequest.builder().individual(individual).build();
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, IndividualResponse.class, new Object[0]);
            Individual createdIndividual = response.getBody() != null ? ((IndividualResponse)response.getBody()).getIndividual() : null;
            log.debug("Successfully created individual with ID: {}", (Object)(createdIndividual != null ? createdIndividual.getIndividualId() : "null"));
            return createdIndividual;
        }
        catch (Exception e) {
            log.error("Failed to create individual", (Throwable)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create individual: " + e.getMessage(), e);
        }
    }

    public Individual getIndividualById(String individualId) {
        if (individualId == null || individualId.trim().isEmpty()) {
            throw new DigitClientException("Individual ID cannot be null or empty");
        }
        try {
            log.debug("Getting individual with ID: {}", (Object)individualId);
            String url = this.apiProperties.getIndividualServiceUrl() + "/individual/v1/" + individualId;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, IndividualResponse.class, new Object[0]);
            Individual individual = response.getBody() != null ? ((IndividualResponse)response.getBody()).getIndividual() : null;
            log.debug("Successfully retrieved individual: {}", (Object)individualId);
            return individual;
        }
        catch (Exception e) {
            log.error("Failed to get individual with ID: {}", (Object)individualId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to get individual: " + e.getMessage(), e);
        }
    }

    public IndividualSearchResponse searchIndividualsByName(String individualName) {
        return this.searchIndividualsByName(individualName, 10, 0);
    }

    public IndividualSearchResponse searchIndividualsByName(String individualName, Integer limit, Integer offset) {
        try {
            log.debug("Searching individuals with name: {}, limit: {}, offset: {}", new Object[]{individualName, limit, offset});
            int finalLimit = limit != null && limit > 0 ? limit : 10;
            int finalOffset = offset != null && offset >= 0 ? offset : 0;
            StringBuilder urlBuilder = new StringBuilder(this.apiProperties.getIndividualServiceUrl() + "/individual/v1?");
            if (individualName != null && !individualName.trim().isEmpty()) {
                urlBuilder.append("individualName=").append(individualName).append("&");
            }
            urlBuilder.append("limit=").append(finalLimit).append("&");
            urlBuilder.append("offset=").append(finalOffset);
            String url = urlBuilder.toString();
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, IndividualSearchResponse.class, new Object[0]);
            IndividualSearchResponse searchResponse = (IndividualSearchResponse)response.getBody();
            log.debug("Successfully retrieved {} individuals", (Object)(searchResponse != null && searchResponse.getIndividuals() != null ? searchResponse.getIndividuals().size() : 0));
            return searchResponse;
        }
        catch (Exception e) {
            log.error("Failed to search individuals with name: {}", (Object)individualName, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to search individuals: " + e.getMessage(), e);
        }
    }

    public IndividualSearchResponse searchAllIndividuals() {
        return this.searchIndividualsByName(null, 10, 0);
    }

    public IndividualSearchResponse searchAllIndividuals(Integer limit, Integer offset) {
        return this.searchIndividualsByName(null, limit, offset);
    }

    public boolean isIndividualExist(String individualId) {
        return this.isIndividualExistsById(individualId, 10, 0);
    }

    public boolean isIndividualExistsById(String individualId, Integer limit, Integer offset) {
        try {
            log.debug("Searching individuals with name: {}, limit: {}, offset: {}", new Object[]{individualId, limit, offset});
            int finalLimit = limit != null && limit > 0 ? limit : 10;
            int finalOffset = offset != null && offset >= 0 ? offset : 0;
            StringBuilder urlBuilder = new StringBuilder(this.apiProperties.getIndividualServiceUrl() + "/individual/v1?");
            if (individualId != null && !individualId.trim().isEmpty()) {
                urlBuilder.append("individualId=").append(individualId).append("&");
            }
            urlBuilder.append("limit=").append(finalLimit).append("&");
            urlBuilder.append("offset=").append(finalOffset);
            String url = urlBuilder.toString();
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, IndividualSearchResponse.class, new Object[0]);
            IndividualSearchResponse searchResponse = (IndividualSearchResponse)response.getBody();
            boolean exists = searchResponse != null && searchResponse.getTotalCount() != null && searchResponse.getTotalCount() > 0L;
            log.debug("Individual with ID {} {}", (Object)individualId, (Object)(exists ? "exists" : "does not exist"));
            return exists;
        }
        catch (Exception e) {
            log.error("Failed to check if individual exists with ID: {}", (Object)individualId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to check if individual exists: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

