/*
 * Decompiled with CFR 0.152.
 */
package com.digit.services.idgen;

import com.digit.config.ApiProperties;
import com.digit.exception.DigitClientException;
import com.digit.services.idgen.model.GenerateIDResponse;
import com.digit.services.idgen.model.IdGenGenerateRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class IdGenClient {
    private static final Logger log = LoggerFactory.getLogger(IdGenClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public IdGenClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        System.out.println("\ud83d\udd0d IdGenClient created with RestTemplate: " + restTemplate.getClass().getSimpleName());
        System.out.println("\ud83d\udd0d RestTemplate interceptors: " + restTemplate.getInterceptors().size());
        restTemplate.getInterceptors().forEach(interceptor -> System.out.println("  - " + interceptor.getClass().getSimpleName()));
    }

    public String generateId(IdGenGenerateRequest generateRequest) {
        if (generateRequest == null) {
            throw new DigitClientException("IdGenGenerateRequest cannot be null");
        }
        if (generateRequest.getTemplateCode() == null || generateRequest.getTemplateCode().trim().isEmpty()) {
            throw new DigitClientException("Template code cannot be null or empty");
        }
        try {
            String generatedId;
            log.debug("Generating ID for templateCode: {}", (Object)generateRequest.getTemplateCode());
            String url = this.apiProperties.getIdgenServiceUrl() + "/idgen/v1/generate";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)generateRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, GenerateIDResponse.class, new Object[0]);
            GenerateIDResponse idResponse = (GenerateIDResponse)response.getBody();
            String string = generatedId = idResponse != null ? idResponse.getId() : null;
            if (generatedId == null || generatedId.trim().isEmpty()) {
                throw new DigitClientException("Generated ID is null or empty");
            }
            log.debug("Successfully generated ID: {}", (Object)generatedId);
            return generatedId;
        }
        catch (Exception e) {
            log.error("Failed to generate ID for templateCode: {}", (Object)generateRequest.getTemplateCode(), (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to generate ID: " + e.getMessage(), e);
        }
    }

    public String generateId(String templateCode, Map<String, String> variables) {
        IdGenGenerateRequest request = IdGenGenerateRequest.builder().templateCode(templateCode).variables(variables).build();
        return this.generateId(request);
    }

    public String generateId(String templateCode) {
        IdGenGenerateRequest request = IdGenGenerateRequest.builder().templateCode(templateCode).build();
        return this.generateId(request);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

