/*
 * Decompiled with CFR 0.152.
 */
package com.digit.services.filestore;

import com.digit.config.ApiProperties;
import com.digit.exception.DigitClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FilestoreClient {
    private static final Logger log = LoggerFactory.getLogger(FilestoreClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public FilestoreClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        log.debug("FilestoreClient created with RestTemplate: {}", (Object)restTemplate.getClass().getSimpleName());
    }

    public boolean isFileAvailable(String fileId, String tenantId) {
        if (fileId == null || fileId.trim().isEmpty()) {
            throw new DigitClientException("File ID cannot be null or empty");
        }
        if (tenantId == null || tenantId.trim().isEmpty()) {
            throw new DigitClientException("Tenant ID cannot be null or empty");
        }
        try {
            log.debug("Getting file with ID: {} for tenant: {}", (Object)fileId, (Object)tenantId);
            String url = this.apiProperties.getFilestoreServiceUrl() + "/filestore/v1/files/" + fileId + "?tenantId=" + tenantId;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            boolean success = response.getStatusCode() == HttpStatus.OK;
            log.debug("File retrieval for ID: {} returned status: {}", (Object)fileId, (Object)response.getStatusCode());
            return success;
        }
        catch (Exception e) {
            log.error("Failed to get file with ID: {} for tenant: {}", new Object[]{fileId, tenantId, e});
            return false;
        }
    }

    public boolean validateFileAvailability(String fileId, String tenantId) {
        if (fileId == null || fileId.trim().isEmpty()) {
            throw new DigitClientException("File ID cannot be null or empty");
        }
        if (tenantId == null || tenantId.trim().isEmpty()) {
            throw new DigitClientException("Tenant ID cannot be null or empty");
        }
        try {
            log.debug("Getting file with validation - ID: {} for tenant: {}", (Object)fileId, (Object)tenantId);
            String url = this.apiProperties.getFilestoreServiceUrl() + "/filestore/v1/files/" + fileId + "?tenantId=" + tenantId;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            boolean success = response.getStatusCode() == HttpStatus.OK;
            log.debug("File retrieval with validation for ID: {} returned status: {}", (Object)fileId, (Object)response.getStatusCode());
            return success;
        }
        catch (Exception e) {
            log.error("Failed to get file with ID: {} for tenant: {}", new Object[]{fileId, tenantId, e});
            if (e.getMessage() != null && (e.getMessage().contains("400") || e.getMessage().contains("401") || e.getMessage().contains("403") || e.getMessage().contains("404"))) {
                throw new DigitClientException("Client error while retrieving file: " + e.getMessage(), e);
            }
            return false;
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

