/*
 * Decompiled with CFR 0.152.
 */
package com.digit.config;

import com.digit.config.ApiProperties;
import com.digit.config.HeaderPropagationInterceptor;
import com.digit.config.PropagationProperties;
import com.digit.services.account.AccountClient;
import com.digit.services.boundary.BoundaryClient;
import com.digit.services.filestore.FilestoreClient;
import com.digit.services.idgen.IdGenClient;
import com.digit.services.individual.IndividualClient;
import com.digit.services.mdms.MdmsClient;
import com.digit.services.notification.NotificationClient;
import com.digit.services.workflow.WorkflowClient;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={RestTemplate.class})
public class HeaderPropagationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ClientHttpRequestInterceptor headerPropagationInterceptor(PropagationProperties props) {
        return new HeaderPropagationInterceptor(props);
    }

    @Bean
    public BeanPostProcessor restTemplateInterceptorProcessor(final PropagationProperties propagationProperties) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof RestTemplate) {
                    RestTemplate restTemplate = (RestTemplate)bean;
                    HeaderPropagationInterceptor interceptor = new HeaderPropagationInterceptor(propagationProperties);
                    ArrayList<HeaderPropagationInterceptor> interceptors = new ArrayList<HeaderPropagationInterceptor>(restTemplate.getInterceptors());
                    interceptors.add(interceptor);
                    restTemplate.setInterceptors(interceptors);
                    System.out.println("\u2705 ADDED HeaderPropagationInterceptor to RestTemplate '" + beanName + "'! Total interceptors: " + interceptors.size());
                }
                return bean;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={BoundaryClient.class})
    public BoundaryClient boundaryClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new BoundaryClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={AccountClient.class})
    public AccountClient accountClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new AccountClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={WorkflowClient.class})
    public WorkflowClient workflowClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new WorkflowClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public IdGenClient idGenClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new IdGenClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public NotificationClient notificationClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new NotificationClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={IndividualClient.class})
    public IndividualClient individualClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new IndividualClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={FilestoreClient.class})
    public FilestoreClient filestoreClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new FilestoreClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={MdmsClient.class})
    public MdmsClient mdmsClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        return new MdmsClient(restTemplate, apiProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="digit.services")
    public ApiProperties apiProperties() {
        return new ApiProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public PropagationProperties propagationProperties() {
        return new PropagationProperties();
    }
}

