/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.workflow;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.workflow.model.WorkflowProcessResponse;
import org.digit.services.workflow.model.WorkflowTransitionRequest;
import org.digit.services.workflow.model.WorkflowTransitionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class WorkflowClient {
    private static final Logger log = LoggerFactory.getLogger(WorkflowClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public WorkflowClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
        System.out.println("\ud83d\udd0d WorkflowClient created with RestTemplate: " + restTemplate.getClass().getSimpleName());
        System.out.println("\ud83d\udd0d RestTemplate interceptors: " + restTemplate.getInterceptors().size());
        restTemplate.getInterceptors().forEach(interceptor -> System.out.println("  - " + interceptor.getClass().getSimpleName()));
    }

    public WorkflowTransitionResponse executeTransition(WorkflowTransitionRequest transitionRequest) {
        if (transitionRequest == null) {
            throw new DigitClientException("WorkflowTransitionRequest cannot be null");
        }
        if (transitionRequest.getProcessId() == null || transitionRequest.getProcessId().trim().isEmpty()) {
            throw new DigitClientException("Process ID cannot be null or empty");
        }
        if (transitionRequest.getEntityId() == null || transitionRequest.getEntityId().trim().isEmpty()) {
            throw new DigitClientException("Entity ID cannot be null or empty");
        }
        if (transitionRequest.getAction() == null || transitionRequest.getAction().trim().isEmpty()) {
            throw new DigitClientException("Action cannot be null or empty");
        }
        try {
            log.debug("Executing workflow transition for processId: {}, entityId: {}, action: {}", new Object[]{transitionRequest.getProcessId(), transitionRequest.getEntityId(), transitionRequest.getAction()});
            String url = this.apiProperties.getWorkflowServiceUrl() + "/workflow/v1/transition";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)transitionRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, WorkflowTransitionResponse.class, new Object[0]);
            WorkflowTransitionResponse transitionResponse = (WorkflowTransitionResponse)response.getBody();
            log.debug("Successfully executed workflow transition. Response ID: {}", (Object)(transitionResponse != null ? transitionResponse.getId() : "null"));
            return transitionResponse;
        }
        catch (Exception e) {
            log.error("Failed to execute workflow transition for processId: {}, entityId: {}", new Object[]{transitionRequest.getProcessId(), transitionRequest.getEntityId(), e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to execute workflow transition: " + e.getMessage(), e);
        }
    }

    public WorkflowTransitionResponse executeTransition(String processId, String entityId, String action, String comment) {
        WorkflowTransitionRequest request = WorkflowTransitionRequest.builder().processId(processId).entityId(entityId).action(action).comment(comment).build();
        return this.executeTransition(request);
    }

    public WorkflowTransitionResponse executeTransition(String processId, String entityId, String action, String comment, Map<String, List<String>> attributes) {
        WorkflowTransitionRequest request = WorkflowTransitionRequest.builder().processId(processId).entityId(entityId).action(action).comment(comment).attributes(attributes).build();
        return this.executeTransition(request);
    }

    public WorkflowProcessResponse getProcessById(String processId) {
        if (processId == null || processId.trim().isEmpty()) {
            throw new DigitClientException("Process ID cannot be null or empty");
        }
        try {
            log.debug("Retrieving workflow process with ID: {}", (Object)processId);
            String url = this.apiProperties.getWorkflowServiceUrl() + "/workflow/v1/process/" + processId;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, WorkflowProcessResponse.class, new Object[0]);
            WorkflowProcessResponse processResponse = (WorkflowProcessResponse)response.getBody();
            log.debug("Successfully retrieved workflow process: {}", (Object)processId);
            return processResponse;
        }
        catch (Exception e) {
            log.error("Failed to retrieve workflow process with ID: {}", (Object)processId, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve workflow process: " + e.getMessage(), e);
        }
    }

    public String getProcessByCode(String code) {
        if (code == null || code.trim().isEmpty()) {
            throw new DigitClientException("Process code cannot be null or empty");
        }
        try {
            log.debug("Retrieving workflow process with code: {}", (Object)code);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.apiProperties.getWorkflowServiceUrl()).append("/workflow/v1/process").append("?code=").append(URLEncoder.encode(code, StandardCharsets.UTF_8));
            String url = urlBuilder.toString();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<WorkflowProcessResponse>>(){}, new Object[0]);
            List processes = (List)response.getBody();
            if (processes == null || processes.isEmpty()) {
                log.warn("No workflow process found for code: {}", (Object)code);
                throw new DigitClientException("No workflow process found for code: " + code);
            }
            String processId = ((WorkflowProcessResponse)processes.get(0)).getId();
            log.debug("Successfully retrieved workflow process ID: {}", (Object)processId);
            return processId;
        }
        catch (Exception e) {
            log.error("Failed to retrieve workflow process for code: {}", (Object)code, (Object)e);
            throw new DigitClientException("Failed to retrieve workflow process: " + e.getMessage(), e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

