/*
 * Decompiled with CFR 0.152.
 */
package org.digit.services.registry;

import org.digit.config.ApiProperties;
import org.digit.exception.DigitClientException;
import org.digit.services.registry.model.RegistryData;
import org.digit.services.registry.model.RegistryDataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RegistryClient {
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private final RestTemplate restTemplate;
    private final ApiProperties apiProperties;

    public RegistryClient(RestTemplate restTemplate, ApiProperties apiProperties) {
        this.restTemplate = restTemplate;
        this.apiProperties = apiProperties;
    }

    public RegistryDataResponse createRegistryData(String schemaCode, RegistryData registryData) {
        if (registryData == null) {
            throw new DigitClientException("Registry data cannot be null");
        }
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryData.getData() == null) {
            throw new DigitClientException("Data cannot be null");
        }
        try {
            log.debug("Creating registry data with schema code: {}", (Object)schemaCode);
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)registryData, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully created registry data with schema code: {}", (Object)schemaCode);
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to create registry data with schema code: {}", (Object)schemaCode, (Object)e);
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to create registry data: " + e.getMessage(), e);
        }
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String registryId, boolean history) {
        if (schemaCode == null || schemaCode.trim().isEmpty()) {
            throw new DigitClientException("Schema code cannot be null or empty");
        }
        if (registryId == null || registryId.trim().isEmpty()) {
            throw new DigitClientException("Registry ID cannot be null or empty");
        }
        try {
            log.debug("Searching registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history});
            String url = this.apiProperties.getRegistryServiceUrl() + "/registry/v1/schema/" + schemaCode + "/data/_registry?registryId=" + registryId + "&history=" + history;
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, RegistryDataResponse.class, new Object[0]);
            log.debug("Successfully retrieved registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history});
            return (RegistryDataResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("Failed to retrieve registry data with schema code: {}, registry ID: {}, and history: {}", new Object[]{schemaCode, registryId, history, e});
            if (e instanceof DigitClientException) {
                throw e;
            }
            throw new DigitClientException("Failed to retrieve registry data: " + e.getMessage(), e);
        }
    }

    public RegistryDataResponse searchRegistryData(String schemaCode, String registryId) {
        return this.searchRegistryData(schemaCode, registryId, false);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ApiProperties getApiProperties() {
        return this.apiProperties;
    }
}

