/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.service;

import javax.jms.Destination;
import org.egov.search.domain.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
public class IndexService {
    private JmsTemplate jmsTemplate;
    private Destination indexQueue;

    @Autowired
    public IndexService(JmsTemplate jmsTemplate, Destination indexQueue) {
        this.jmsTemplate = jmsTemplate;
        this.indexQueue = indexQueue;
    }

    public void index(Document document) {
        this.jmsTemplate.send(this.indexQueue, session -> session.createTextMessage(document.toJSONString()));
    }
}

