/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.domain.resource;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.egov.search.domain.Searchable;
import org.egov.search.domain.resource.CollectionType;
import org.egov.search.domain.resource.DateType;
import org.egov.search.domain.resource.MapType;
import org.egov.search.domain.resource.NestedType;
import org.egov.search.domain.resource.SimpleType;
import org.egov.search.util.Beans;

public abstract class Type {
    protected Field field;

    public Type(Field field) {
        this.field = field;
    }

    public static Type newInstanceFor(Field field, Class<?> fieldClazz) {
        if (Collection.class.isAssignableFrom(fieldClazz)) {
            return new CollectionType(field);
        }
        if (Map.class.isAssignableFrom(fieldClazz)) {
            return new MapType(field);
        }
        if (Date.class.isAssignableFrom(fieldClazz)) {
            return new DateType(field);
        }
        Searchable searchable = fieldClazz.getAnnotation(Searchable.class);
        if (searchable != null) {
            return new NestedType(field);
        }
        return new SimpleType(field);
    }

    public Object jsonValue(Object object) {
        Object fieldValue = Beans.readPropertyValue(object, this.field);
        return this.retrieveJsonValue(fieldValue);
    }

    protected abstract Object retrieveJsonValue(Object var1);

    protected boolean isSearchable(Object object) {
        return object != null && object.getClass().getAnnotation(Searchable.class) != null;
    }
}

