/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.domain;

import java.util.ArrayList;
import java.util.List;
import org.egov.search.domain.Document;
import org.egov.search.service.SearchResultTransformer;

public class SearchResult {
    private String response;
    private List<Document> documents;

    SearchResult(String response, List<Document> documents) {
        this.response = response;
        this.documents = documents;
    }

    public static SearchResult from(String response) {
        List<Document> documentList = new ArrayList<Document>(0);
        if (response != null && !"".equals(response)) {
            documentList = new SearchResultTransformer().transform(response);
        }
        return new SearchResult(response, documentList);
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public String rawResponse() {
        return this.response;
    }

    public boolean isEmpty() {
        return this.documents == null || this.documents.size() == 0;
    }

    public int documentCount() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getDocuments().size();
    }
}

