/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.domain;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.egov.search.domain.Filter;
import org.egov.search.domain.NoOpFilter;

public class Filters {
    public static final Filters NULL = new Filters();
    private List<Filter> andFilters;
    private List<Filter> orFilters;
    private List<Filter> notInFilters;

    private Filters() {
        this(Arrays.asList(new Filter[0]), Arrays.asList(new Filter[0]), Arrays.asList(new Filter[0]));
    }

    private Filters(List<Filter> andFilters, List<Filter> orFilters, List<Filter> notInFilters) {
        this.andFilters = this.removeNoOpFilters(andFilters);
        this.orFilters = this.removeNoOpFilters(orFilters);
        this.notInFilters = this.removeNoOpFilters(notInFilters);
    }

    public static Filters withAndFilters(List<Filter> andFilters) {
        return Filters.withAndPlusOrFilters(andFilters, Arrays.asList(new Filter[0]));
    }

    public static Filters withOrFilters(List<Filter> orFilters) {
        return Filters.withAndPlusOrFilters(Arrays.asList(new Filter[0]), orFilters);
    }

    public static Filters withAndPlusOrFilters(List<Filter> andFilters, List<Filter> orFilters) {
        return new Filters(andFilters, orFilters, Arrays.asList(new Filter[0]));
    }

    public static Filters withAndPlusNotFilters(List<Filter> andFilters, List<Filter> notFilters) {
        return new Filters(andFilters, Arrays.asList(new Filter[0]), notFilters);
    }

    public static Filters withOrPlusNotFilters(List<Filter> orFilters, List<Filter> notFilters) {
        return new Filters(Arrays.asList(new Filter[0]), orFilters, notFilters);
    }

    private List<Filter> removeNoOpFilters(List<Filter> filters) {
        return filters.stream().filter(f -> !(f instanceof NoOpFilter)).collect(Collectors.toList());
    }

    public List<Filter> getAndFilters() {
        return this.andFilters;
    }

    public List<Filter> getOrFilters() {
        return this.orFilters;
    }

    public List<Filter> getNotInFilters() {
        return this.notInFilters;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.andFilters.isEmpty() && this.orFilters.isEmpty() && this.notInFilters.isEmpty();
    }
}

