/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.config;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SearchConfig {
    private Properties properties;

    @Autowired
    public SearchConfig(@Qualifier(value="egovSearchProperties") Properties properties) {
        this.properties = properties;
    }

    public List<String> searchHosts() {
        return Arrays.asList(this.properties.getProperty("search.hosts").split(","));
    }

    public int searchPort() {
        return Integer.parseInt(this.properties.getProperty("search.port"));
    }

    public String searchClusterName() {
        return this.properties.getProperty("search.clusterName");
    }

    public int searchShardsFor(String indexName) {
        String noOfShards = this.properties.getProperty(String.format("search.%s.shards", indexName));
        if (StringUtils.isBlank((String)noOfShards)) {
            throw new RuntimeException(String.format("No of shards are not defined for %s, verify 'search.%s.shards' entry", indexName, indexName));
        }
        return Integer.valueOf(noOfShards);
    }

    public int searchReplicasFor(String indexName) {
        String noOfReplicas = this.properties.getProperty(String.format("search.%s.replicas", indexName));
        if (StringUtils.isBlank((String)noOfReplicas)) {
            throw new RuntimeException(String.format("No of replicas are not defined for %s, verify 'search.%s.replicas' entry ", indexName));
        }
        return Integer.valueOf(noOfReplicas);
    }
}

